// TXTI.CPP
//
//  2005 Nokia Corporation.  All rights reserved.
//



// class include
#include "txti.h"

// Standard includes
#include <bautils.h>
#include <coemain.h>	// CCoeEnv

// Messaging includes
#include <msvstd.hrh>
#include <mtclbase.h> 
#include <mtmdef.hrh>
#include <msvids.h>
#include <msvuids.h>
#include <mtmuidef.hrh>
#include <stringloader.h>        // StringLoader
#include <AknsSkinInstance.h>
#include <AknsUtils.h>
#include <aknsconstants.h>//skinned icon ids

#include <txti.rsg>
#include <txti.mbg>

//
#include <akniconutils.h>
// user includes
#include "txclient.h"
#include "txtipan.h"

// user includes
#include "txut.h"
#include "txtucmds.hrh"
#include "../../Client/inc/txclient.h"
#include "txtipan.h"

// eikcore.rsg
#include <eikcore.rsg>

#ifdef __WINS__
	#pragma message("If you use an IDE, build from the command line first to create the bitmaps file and .mbg header")
#endif

// Constants
const TInt KTxtiMtmUdNumberOfIconSets =		3;
const TInt KTxtMtmArrayGranularity  = 18;

_LIT(KTxtiMtmUdResourceFile,"TXTI.RSC");
_LIT(KTxtiMtmUdBitmapFile,"TXTI.MIF");
#ifdef __WINS__
// on wins, assume built to z:
_LIT(KTxtiMtmUdPath,"\\resource\\messaging\\");
#else
_LIT(KTxtiMtmUdPath,"c:\\resource\\messaging\\");
#endif //WINS


// This constant is required so that the series 60 messaging application knows that the TextMTM
// can be used to create a message
#define KUidMtmQueryCanCreateNewMsgValue 0x10008b24

//
// CTxtiMtmUiData: UI Data MTM
//

//
//	Construction, initialisation, and destruction
//


enum TIcons 
	{
	EMailRead,
	EMailUnread,
	EService
	};

EXPORT_C CTxtiMtmUiData* CTxtiMtmUiData::NewL(CRegisteredMtmDll& aRegisteredDll)
	{
	CTxtiMtmUiData* base=new(ELeave) CTxtiMtmUiData(aRegisteredDll);
	CleanupStack::PushL(base);
	base->TxtConstructL();
	CleanupStack::Pop(base);
	return base;
	}

void CTxtiMtmUiData::TxtConstructL()
    {
    
	iIconArrays = new (ELeave) CArrayPtrSeg<CBitmapArray>(KTxtMtmArrayGranularity);
	iMtmSpecificFunctions = new (ELeave) CArrayFixFlat<TMtmUiFunction>(KTxtMtmArrayGranularity);

	// Get resource file
	TFileName resourceFileName;

    TxtUtils::FindFileL(KTxtiMtmUdResourceFile, KTxtiMtmUdPath, resourceFileName);
    iResourceFileName = resourceFileName.AllocL();

	// Now try to find a resource file that matches the particular locale, if one
    // exists and the locale has been set
	BaflUtils::NearestLanguageFile(iCoeEnv->FsSession(), resourceFileName);

	// Add the resource file to the CCoeEnv
    iNewResourceFileOffset=iCoeEnv->AddResourceFileL(resourceFileName);

	// finally, populate the arrays
    PopulateArraysL();
    }



void CTxtiMtmUiData::TxtCreateBitmapsL(const TDesC& aBitmapFile)
	{
    CFbsBitmap* bitmap;
    CFbsBitmap* bitmapMask;

    TBool found = ETrue;

    for( TInt i = EMbmTxtiRead; 
              i < EMbmTxtiLastElement; 
              i++ )
        {
        found = ETrue;
        switch( i )
            {
            // Add to iIconArrays in this order
            case EMbmTxtiRead:
                break;
            case EMbmTxtiUnread:
                break;
            case EMbmTxtiMailbox:
                break;
            default:
                found = EFalse;
                break;
            }
        if( found )
            {
            CArrayPtrFlat<CFbsBitmap>* array = 
                new (ELeave) CArrayPtrFlat<CFbsBitmap>(  KTxtMtmArrayGranularity  );
            CleanupStack::PushL( array );

            array->SetReserveL(  KTxtMtmArrayGranularity ); // AppendLs will not LEAVE
            TInt err=0;
            TRAP(err, AknIconUtils::CreateIconL(bitmap, bitmapMask, 
                                   aBitmapFile, i, i + 1 ));
            array->AppendL( bitmap );
            bitmap = 0;
            array->AppendL( bitmapMask );
            bitmapMask = 0;
            iIconArrays->AppendL( array );
            CleanupStack::Pop( array ); // array
            }
     	}
    return;
	}



CTxtiMtmUiData::~CTxtiMtmUiData()
	{
	// remove the resource file we added to the CCoeEnv
	if (iNewResourceFileOffset != 0)
	    iCoeEnv->DeleteResourceFile(iNewResourceFileOffset);
    delete iResourceFileName;
	
	
	
	
	}



// Initialise bitmaps and function information
void CTxtiMtmUiData::PopulateArraysL()
	{
	// Read MTM-specific operation information
	ReadFunctionsFromResourceFileL(R_TEXTUD_FUNCTION_ARRAY);

	// Populate bitmap array
	TFileName bitmapFileName;
	TxtUtils::FindFileL(KTxtiMtmUdBitmapFile, KTxtiMtmUdPath, bitmapFileName);

	TxtCreateBitmapsL(bitmapFileName);
	}




CTxtiMtmUiData::CTxtiMtmUiData(CRegisteredMtmDll& aRegisteredDll)
	:	CBaseMtmUiData(aRegisteredDll)
	{
    }


void CTxtiMtmUiData::GetResourceFileName(TFileName& aFileName) const
// Resource file loading
	{
	aFileName=*iResourceFileName;
	}


//
//	MTM-specific functionality
//


// Context-sensitive operation query
TInt CTxtiMtmUiData::OperationSupportedL(TInt aOperationId, const TMsvEntry& aContext) const
	{
	TInt aReasonResourceId=0;	// 0 means "operation is available"

	if (aContext.iMtm!=KUidMsgTypeText)
        return R_TEXTUD_NOT_SUPPORTED;

	const TBool isMessage = (aContext.iType==KUidMsvMessageEntry);
	const TBool isService = (aContext.iType==KUidMsvServiceEntry);

	if (aOperationId==ETxtuCommandRefreshMBox)
		{
		// Only allow refresh on services
		if (!isService)
    		aReasonResourceId=R_TEXTUD_ONLY_REFRESH_SERVICES;
		}
	else if (aOperationId==ETxtuCommandMessage)
		{
		// Only allow this command on local messages
		if ( (!isMessage) || (aContext.iServiceId != KMsvLocalServiceIndexEntryId) )
    		aReasonResourceId=R_TEXTUD_ONLY_MESSAGES;
		}
	return aReasonResourceId;
	}


TInt CTxtiMtmUiData::QueryCapability(TUid aCapability, TInt& aResponse) const
// Query for capability
	{
	switch (aCapability.iUid)
		{
	// Supported valued capabilities
	case KUidMtmQueryMaxBodySizeValue:
		aResponse=KMaxTextMessageSize;
		break;
	case KUidMtmQueryMaxTotalMsgSizeValue:
		aResponse=KMaxTextMessageSize;
		break;

	// Supported non-valued capabilities

	case KUidMtmQuerySupportedBodyValue:
	case KUidMtmQueryOffLineAllowedValue:
	case KUidMtmQueryCanReceiveMsgValue:
	case KUidMtmQueryCanSendMsgValue:	
	case KUidMtmQueryCanCreateNewMsgValue:
		aResponse=0;
		break;

	default:
		return KErrNotSupported;
		};
	return KErrNone;
	}


const CBaseMtmUiData::CBitmapArray& CTxtiMtmUiData::ContextIcon(const TMsvEntry& aContext, TInt /*aStateFlags*/) const
	{
	__ASSERT_ALWAYS(aContext.iMtm==KUidMsgTypeText, Panic(ETxtiMtmUdWrongMtm));
	__ASSERT_ALWAYS(aContext.iType!=KUidMsvAttachmentEntry, Panic(ETxtiMtmUdNoIconForAttachment));

	TInt retIndex=EService;
	// If it is a folder or a service use the same icon
	if (aContext.iType == KUidMsvServiceEntry ||aContext.iType == KUidMsvFolderEntry )
		{
		retIndex=EService;
		}
	else 
		{
		// if it is a message, check whether the message is read or unread	
		// and select the right icon
		if (aContext.iType == KUidMsvMessageEntry)
			retIndex=aContext.Unread() ?  EMailUnread : EMailRead;
		}
		
	return *(iIconArrays->At(retIndex));
	}

//
// Context-specific information
//

TBool CTxtiMtmUiData::CanOpenEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const
	{
	__ASSERT_ALWAYS(aContext.iMtm==KUidMsgTypeText, Panic(ETxtiMtmUdWrongMtm));
	__ASSERT_ALWAYS(aContext.iType!=KUidMsvAttachmentEntry, Panic(ETxtiMtmUdAttachmentsNotSupported));

	aReasonResourceId=R_EIK_TBUF_NOT_AVAILABLE;
	if ( aContext.iType != KUidMsvMessageEntry )
		{
		aReasonResourceId=R_TEXTUD_ONLY_MESSAGES;
		return EFalse;
		}
	else
		return ETrue;
	}


TBool CTxtiMtmUiData::CanCloseEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const
	{
	__ASSERT_ALWAYS(aContext.iMtm==KUidMsgTypeText, Panic(ETxtiMtmUdWrongMtm));
	__ASSERT_ALWAYS(aContext.iType!=KUidMsvAttachmentEntry, Panic(ETxtiMtmUdAttachmentsNotSupported));

	aReasonResourceId=R_EIK_TBUF_NOT_AVAILABLE;
	if ( aContext.iType != KUidMsvMessageEntry )
		{
		aReasonResourceId=R_TEXTUD_ONLY_MESSAGES;
		return EFalse;
		}
	else
		return ETrue;
	}


TBool CTxtiMtmUiData::CanViewEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const
	{
	__ASSERT_ALWAYS(aContext.iMtm==KUidMsgTypeText, Panic(ETxtiMtmUdWrongMtm));
	__ASSERT_ALWAYS(aContext.iType!=KUidMsvAttachmentEntry, Panic(ETxtiMtmUdAttachmentsNotSupported));

	aReasonResourceId=R_EIK_TBUF_NOT_AVAILABLE;
	if ( aContext.iType != KUidMsvMessageEntry )
		{
		aReasonResourceId=R_TEXTUD_ONLY_MESSAGES;
		return EFalse;
		}
	else
		return ETrue;
	}


TBool CTxtiMtmUiData::CanEditEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const
	{
	__ASSERT_ALWAYS(aContext.iMtm==KUidMsgTypeText, Panic(ETxtiMtmUdWrongMtm));
	__ASSERT_ALWAYS(aContext.iType!=KUidMsvAttachmentEntry, Panic(ETxtiMtmUdAttachmentsNotSupported));

	aReasonResourceId=R_EIK_TBUF_NOT_AVAILABLE;
	if ( aContext.iType == KUidMsvFolderEntry )
		{
		aReasonResourceId=R_TEXTUD_CAN_NOT_EDIT_FOLDERS;
		return EFalse;
		}
	else
		return ETrue;
	}


TBool CTxtiMtmUiData::CanDeleteFromEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const
	{
	__ASSERT_ALWAYS(aContext.iMtm==KUidMsgTypeText, Panic(ETxtiMtmUdWrongMtm));
	__ASSERT_ALWAYS(aContext.iType!=KUidMsvAttachmentEntry, Panic(ETxtiMtmUdAttachmentsNotSupported));

	aReasonResourceId=R_EIK_TBUF_NOT_AVAILABLE;    // There is no resource string for this operation
	return EFalse;
	}


TBool CTxtiMtmUiData::CanCopyMoveToEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const
	{
	__ASSERT_ALWAYS(aContext.iMtm==KUidMsgTypeText, Panic(ETxtiMtmUdWrongMtm));
	__ASSERT_ALWAYS(aContext.iType!=KUidMsvAttachmentEntry, Panic(ETxtiMtmUdAttachmentsNotSupported));

	aReasonResourceId=R_EIK_TBUF_NOT_AVAILABLE;    // There is no resource string for this operation
	return EFalse;
	}


TBool CTxtiMtmUiData::CanCopyMoveFromEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const
	{
	__ASSERT_ALWAYS(aContext.iMtm==KUidMsgTypeText, Panic(ETxtiMtmUdWrongMtm));
	__ASSERT_ALWAYS(aContext.iType!=KUidMsvAttachmentEntry, Panic(ETxtiMtmUdAttachmentsNotSupported));

	aReasonResourceId=R_EIK_TBUF_NOT_AVAILABLE;    // There is no resource string for this operation
	return EFalse;
	}


TBool CTxtiMtmUiData::CanReplyToEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const
//
// MTM UI does not support replying.
//
    {
	__ASSERT_ALWAYS(aContext.iMtm==KUidMsgTypeText, Panic(ETxtiMtmUdWrongMtm));
	__ASSERT_ALWAYS(aContext.iType!=KUidMsvAttachmentEntry, Panic(ETxtiMtmUdAttachmentsNotSupported));

	aReasonResourceId=R_TEXTUD_NOT_SUPPORTED;
	return EFalse;
    }


TBool CTxtiMtmUiData::CanForwardEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const
//
// MTM UI does not supports forwarding.
//
    {
	__ASSERT_ALWAYS(aContext.iMtm==KUidMsgTypeText, Panic(ETxtiMtmUdWrongMtm));
	__ASSERT_ALWAYS(aContext.iType!=KUidMsvAttachmentEntry, Panic(ETxtiMtmUdAttachmentsNotSupported));

	aReasonResourceId=R_TEXTUD_NOT_SUPPORTED;
	return EFalse;
    }


TBool CTxtiMtmUiData::CanCreateEntryL(const TMsvEntry& aParent, TMsvEntry& aNewEntry,
									  TInt& aReasonResourceId) const
	{
	__ASSERT_ALWAYS(aNewEntry.iMtm==KUidMsgTypeText, Panic(ETxtiMtmUdWrongMtm));
	__ASSERT_ALWAYS(aNewEntry.iType!=KUidMsvAttachmentEntry, Panic(ETxtiMtmUdAttachmentsNotSupported));

	aReasonResourceId=R_EIK_TBUF_NOT_AVAILABLE;    // There is no resource string for this operation
	// --- Can create services if they are off root ---
	if (aNewEntry.iType == KUidMsvServiceEntry)
		return (aParent.Id() == KMsvRootIndexEntryIdValue);

	// --- Can create messages in local folders ---
	if (aNewEntry.iType == KUidMsvMessageEntry)
		return (aParent.iMtm.iUid == KMsvLocalServiceIndexEntryIdValue);
	
	return EFalse;
	}

TBool CTxtiMtmUiData::CanDeleteServiceL(const TMsvEntry& aService, TInt& aReasonResourceId)const
	{
	__ASSERT_ALWAYS(aService.iMtm==KUidMsgTypeText, Panic(ETxtiMtmUdWrongMtm));

	aReasonResourceId=R_EIK_TBUF_NOT_AVAILABLE;    // There is no resource string for this operation
	return EFalse;
	}

TBool CTxtiMtmUiData::CanCancelL(const TMsvEntry& /*aContext*/, TInt& /*aReasonResourceId*/) const
	{
	return EFalse;
	}

HBufC* CTxtiMtmUiData::StatusTextL(const TMsvEntry& /*aContext*/) const
	{
	return StringLoader::LoadL(R_TEXTUD_STATUS_TEXT, iCoeEnv );
	}
