

#ifndef __TXTVIEWVERAPPVIEW_H__
#define __TXTVIEWVERAPPVIEW_H__

// INCLUDES
#include <eikedwin.h> 
#include "EIKRTED.H"
#include <TXTCMDS.HRH>
#include <coecntrl.h>
#include <MSVSTD.H>
#include <msvapi.h>
class CTextMtmClient; 
class CTextMtmUi; 

class CMsvSession;
class CMsvStore;
class CEikRichTextEditor;
class CClientMtmRegistry;
class CMtmUiRegistry;
class CMsvOperation;
class CMsvEntrySelection;
// CLASS DECLARATION
class TDummyObserver : public MMsvSessionObserver
	{
public:
	void HandleSessionEventL(TMsvSessionEvent /*aEvent*/, TAny* /*aArg1*/, TAny* /*aArg2*/, TAny* /*aArg3*/) {};
	};
class CTxtViewerAppView : public CCoeControl
    {
    public: // New methods
		TRequestStatus* it;
		CMsvOperation* iop;
		CMsvEntrySelection* iselection;
		
		TBuf8<1> iscrap;
        
        //Loads body from the store to the editor
        void LoadBodyL();

        //Saves body from the editor to the store
        void SaveBodyL();

        void ExportToFileL( const TDes& aFileName );

		CTextMtmUi* UiMtm() 
		{
			return iUiMtm;
		}
		
		TMsvId EntryId();

		TBool OpenedForEditing();
		
		void Notify();
		
        /**
        * NewL.
        * Two-phased constructor.
        * Create a CTxtViewerAppView object, which will draw itself to aRect.
        * @param aRect The rectangle this view will be drawn to.
        * @return a pointer to the created instance of CTxtViewerAppView.
        */
        static CTxtViewerAppView* NewL( const TRect& aRect );

        /**
        * NewLC.
        * Two-phased constructor.
        * Create a CTxtViewerAppView object, which will draw itself
        * to aRect.
        * @param aRect Rectangle this view will be drawn to.
        * @return A pointer to the created instance of CTxtViewerAppView.
        */
        static CTxtViewerAppView* NewLC( const TRect& aRect );

        /**
        * ~CTxtViewerAppView
        * Virtual Destructor.
        */
        virtual ~CTxtViewerAppView();

    public:  // Functions from base classes
void InitializeMTMsL();
        
        /**
        * From CCoeControl, Draw
        * Draw this CTxtViewerAppView to the screen.
        * @param aRect the rectangle of this view that needs updating
        */
        void Draw( const TRect& aRect ) const;

        /**
        * From CoeControl, SizeChanged.
        * Called by framework when the view size is changed.
        */
        virtual void SizeChanged();

	   TKeyResponse OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType);



    private: // Constructors

        /**
        * ConstructL
        * 2nd phase constructor.
        * Perform the second phase construction of a
        * CTxtViewerAppView object.
        * @param aRect The rectangle this view will be drawn to.
        */
        void ConstructL(const TRect& aRect);

        /**
        * CTxtViewerAppView.
        * C++ default constructor.
        */
        CTxtViewerAppView();
        
      
        
        
        

	private:
		CMsvSession* iSession;
		CMsvStore* iStore;
		CEikRichTextEditor* iEditor;
		HBufC* iText;
		CTextMtmClient* iClientMtm; 
		CTextMtmUi* iUiMtm; 
		CClientMtmRegistry* iClientReg;
		CMtmUiRegistry* iUiReg;

		TDummyObserver iOb;
		

    };

#endif // __TXTVIEWVERAPPVIEW_H__

// End of File

