/*
* ============================================================================
*  Name     : CTxtViewerService 
*
*  Description:
*     Server-side message editor/viewer service
*
*  Version:
*
*  Copyright (C) 2004 Nokia Corporation.
*  This material, including documentation and any related 
*  computer programs, is protected by copyright controlled by 
*  Nokia Corporation. All rights are reserved. Copying, 
*  including reproducing, storing,  adapting or translating, any 
*  or all of this material requires the prior written consent of 
*  Nokia Corporation. This material also contains confidential 
*  information which may not be disclosed to others without the 
*  prior written consent of Nokia Corporation.
*
* ============================================================================
*/

#ifndef TXTEDITORSERVICESESSION_H
#define TXTEDITORSERVICESESSION_H

#include <f32file.h>
#include <eikdoc.h>
#include <AknServerApp.h>


enum TTxtViewerServiceCmds
	{
	ETxtViewerServiceCmdOpen = RApaAppServiceBase::KServiceCmdBase
	};

class CTxtViewerServiceSession : public CAknAppServiceBase
	{
	public:
		/**
		* C++ Constructor
		*/
		IMPORT_C CTxtViewerServiceSession();
		
		/**
		* C++ Destructor
		*/
		~CTxtViewerServiceSession();

	protected: // from CSession2
		/**
		* Just basecalls CAknAppServiceBase
		*/
		void CreateL();
		
		void ServiceL(const RMessage2& aMessage);
		
		/**
		* Basecalls CAknAppServiceBase.
		*/
		void ServiceError(const RMessage2& aMessage,TInt aError);

	private:
		/**
		* Constructs TEditorParameters from aMessage */
		
		
		void OpenL( const RMessage2& aMessage );

	private:
		CEikDocument* iDoc;
	};

#endif
