

// INCLUDE FILES

// UIKON/AVKON
#include <akntitle.h>                   // CAknTitlePane
#include <eikmenub.h>                   // CEikMenuBar
#include <aknnotewrappers.h>            // AknNoteWrappers
#include <txtrich.h>                    // Rich text
#include <f32file.h>

// messaging editors
#include <eikrted.h>                    // CEikRichTextEditor

// local
#include "txtviewer.hrh"             // application specific commands
#include "txtviewerappview.h"            // CTxtViewerDocument
#include "txtviewerappui.h"          // CTxtViewerAppUi
#include "txtviewerdoc.h"          // CTxtViewerAppUi
#include "../../UI/inc/txtu.h"   
#include <msvids.h>

// Find item
// general
#include <CentralRepository.h>

#include <txtviewer.rsg>
// Txt editor executable Uid 
const TUid KUidTxtViever ={0xA00058BC};
_LIT(KTextMTMMsgPath, "C:\\data\\TextMTMService\\");

// Txt Mtm Service Uid
const TUid KUidTxtMtm = {0x10FFFFFF};



// ================= MEMBER FUNCTIONS =======================

// C++ default constructor can NOT contain any code, that
// might leave.
CTxtViewerAppUi::CTxtViewerAppUi() 
    {
    }

// Symbian OS default constructor can leave.
void CTxtViewerAppUi::ConstructL()
    {
  	BaseConstructL(EAknEnableSkin);
  	iAppView = CTxtViewerAppView::NewL( ClientRect() );
    AddToStackL( iAppView );
	Document()->SetView(iAppView);
    }   
    

// Destructor
CTxtViewerAppUi::~CTxtViewerAppUi()
    {

    if (iAppView) 
	   	{
	   	RemoveFromStack(iAppView);
	    delete iAppView;
	   
	   	}
    }

// ---------------------------------------------------------
// CTxtViewerAppUi::Document
// (other items were commented in a header).
// ---------------------------------------------------------
CTxtViewerDocument* CTxtViewerAppUi::Document() const
    {
    return static_cast<CTxtViewerDocument*>(CEikAppUi::Document());
    }



// ---------------------------------------------------------
// CTxtViewerAppUi::DynInitMenuPaneL
// (other items were commented in a header).
// ---------------------------------------------------------
void CTxtViewerAppUi::DynInitMenuPaneL(
    TInt aMenuId, 
    CEikMenuPane* aMenuPane )
    {
     switch ( aMenuId )
        {
        case R_TEXTMTMVIEW_MENU:
            {
            if ( !iAppView->OpenedForEditing() ) // editor
              	{
                aMenuPane->SetItemDimmed( ETxtViewerSend, ETrue );
                aMenuPane->SetItemDimmed( ETxtViewerSaveToDrafts, ETrue );
			
  	          	}
    		}
        }
    }

// ---------------------------------------------------------
// CTxtViewerAppUi::HandleCommandL
// (other items were commented in a header).
// ---------------------------------------------------------
void CTxtViewerAppUi::HandleCommandL(TInt aCommand )
    {

  
    switch( aCommand )
		{
		case EEikCmdExit:
		case EAknSoftkeyExit:
		case EAknSoftkeyBack:
		     Exit();

		case ETxtViewerSend:
			 
			iAppView->SaveBodyL();
	 		SendL();
		    Exit();
		    break;

		case ETxtViewerSaveToDrafts:
	
	   		iAppView->SaveBodyL();
			SaveToDraftsL();
			Exit();
		    break;
				
			
		default:

		    break;
		}
    }

// ---------------------------------------------------------
// CTxtViewerAppUi::HandleKeyEventL
// (other items were commented in a header).
// ---------------------------------------------------------
TKeyResponse CTxtViewerAppUi::HandleKeyEventL(
    const TKeyEvent& /*aKeyEvent*/, 
    TEventCode /*aType*/ )
    {
    return EKeyWasConsumed; 
    }

void CTxtViewerAppUi::SaveToDraftsL() 
	{
	CTextMtmUi* iMtmUi = iAppView->UiMtm();

	iMtmUi->BaseMtm().SwitchCurrentEntryL(Document()->Id());

	TMsvEntry entry = iMtmUi->BaseMtm().Entry().Entry();
	
	// These flags must be set
	entry.SetInPreparation(EFalse);

	entry.SetVisible(ETrue);

	entry.iServiceId = KMsvLocalServiceIndexEntryId;
	
	CMsvEntry& msventry = iMtmUi->BaseMtm().Entry();

	msventry.ChangeL(entry);	
		
		
	}

void CTxtViewerAppUi::SendL() 
	{
	CTextMtmUi* iMtmUi = iAppView->UiMtm();
		

	// Creata a new entry selection array 
	CMsvEntrySelection* selection = new (ELeave) CMsvEntrySelection();
	
	CleanupStack::PushL(selection);

	TMsvEntry entry = iMtmUi->BaseMtm().Entry().Entry();
	
	
	// These flags must be set before sending
	entry.SetInPreparation(EFalse);
	
	entry.SetVisible(ETrue);

	entry.iServiceId = KMsvLocalServiceIndexEntryId;

	CMsvEntry& msventry = iMtmUi->BaseMtm().Entry();

	msventry.SetEntryL(Document()->Id());

	msventry.ChangeL(entry);	
	// Add the edited item to the array
	selection->AppendL(Document()->Id());

	iMtmUi->BaseMtm().SwitchCurrentEntryL(KMsvSentEntryId/*iMtmUi->BaseMtm().DefaultServiceL()*/);

	CMsvOperationActiveSchedulerWait* wait=CMsvOperationActiveSchedulerWait::NewLC();

    CMsvOperation* op =	NULL;
	
    op = iMtmUi->MoveToL(*selection, wait->iStatus);

	CleanupStack::PushL(op);

	wait->Start();

    RFile file;
    RFs fs;
    fs.Connect();
    TBuf<256> filename;
    filename.Append(KTextMTMMsgPath);
    filename.Append(_L("message"));
    _LIT(KTimeFormat,"%H%T");
    TBuf <10> timeBuf;
    TTime myTime;
    myTime.HomeTime();
    myTime.FormatL(timeBuf, KTimeFormat);    
    filename.Append(timeBuf);
    filename.Append(_L(".txt"));

    if (file.Open(fs, filename,EFileWrite) == KErrNotFound)
        {
        file.Create(fs, filename,EFileWrite);
        }
    TInt pos;
    file.Seek(ESeekEnd, pos);

    file.Close();
    fs.Close();

    iAppView->ExportToFileL( filename );

    CleanupStack::PopAndDestroy(3);
    }


// ---------------------------------------------------------
// CTxtViewerAppUi::HandleStatusPaneSizeChange()
// Called by framework when resource is changed.
// ---------------------------------------------------------
//
void CTxtViewerAppUi::HandleStatusPaneSizeChange()
	{
	CAknAppUi::HandleStatusPaneSizeChange(); //call to upper class
	iAppView->SetRect( ClientRect() );
	}
