

// INCLUDE FILES
#include <coemain.h>
#include <EIKENV.H> 

#include <eikdef.h>
#include <coeaui.h>
#include "txtviewerdoc.h"
#include "EIKAPPUI.H"
#include <aknutils.h> //LayoutUtils

//Messaging related

#include <mtclreg.h>
#include <mtuireg.h>
#include <MTUDREG.H> 
#include <MTUIREG.H> 
#include <msvids.h>
#include <TXTRICH.H>

#include <MTCLBASE.H> // SwitchCurrentEntryL


#include "TxtViewerAppView.h"
#include "TxtViewerAppUi.h"
#include "../../Client/inc/txclient.h"
#include "../../UI/inc/txtu.h"

const TInt KNumberOfLines = 5;
const TInt KTextLimit = 100;



void CTxtViewerAppView::Notify()
	{
			// Change CBA if we are not editing 
	CEikButtonGroupContainer* container = iEikonEnv->AppUiFactory()->Cba();		

	if (!OpenedForEditing())
		{
		container->SetCommandSetL(R_AVKON_SOFTKEYS_BACK);
		}
	else 
		{
		container->SetCommandSetL(R_AVKON_SOFTKEYS_OPTIONS_BACK);
		}

	container->DrawDeferred();

	// Create a window for this application view
    CreateWindowL();

	// Initialize component array
	InitComponentArrayL(); 		// call once

	// Create a new editor
	iEditor = new(ELeave) CEikRichTextEditor;

	// Add editor to the array
	Components().AppendLC(iEditor); 

	TBool edit = OpenedForEditing();
	

	TInt editorflags(0);	
		
	if (edit) 
		{
		editorflags=0;			
		}
	else 
		{
		editorflags=EEikEdwinReadOnly;
		}
	
	
	iEditor->ConstructL( this, KNumberOfLines, KTextLimit, 
        editorflags, EGulFontControlAll, EGulNoSymbolFonts );
    
    // Create a scrollbar for it
    iEditor->CreateScrollBarFrameL()->SetScrollBarVisibilityL( CEikScrollBarFrame::EOff,
        CEikScrollBarFrame::EOn );
	
	// Editor off the cleanup stack
	CleanupStack::Pop(iEditor);

	iEditor->SetContainerWindowL(*this);
    iEditor->SetFocus(ETrue);

	TRect rect;

	AknLayoutUtils::LayoutMetricsRect( AknLayoutUtils::EMainPane, rect );
	iEditor->SetRect( TRect(TPoint(0,0),rect.Size()) );
	iEditor->ActivateL();

    // Set the windows size
    SetRect(rect);

    // Activate the window, which makes it ready to be drawn
    ActivateL();
	
	InitializeMTMsL();
	
	LoadBodyL();		
	}
// ============================ MEMBER FUNCTIONS ===============================

// -----------------------------------------------------------------------------
// CTxtViewerAppView::NewL()
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CTxtViewerAppView* CTxtViewerAppView::NewL( const TRect& aRect )
    {
    CTxtViewerAppView* self = CTxtViewerAppView::NewLC( aRect );
    CleanupStack::Pop( self );
    return self;
    }

// -----------------------------------------------------------------------------
// CTxtViewerAppView::NewLC()
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CTxtViewerAppView* CTxtViewerAppView::NewLC( const TRect& aRect )
    {
    CTxtViewerAppView* self = new ( ELeave ) CTxtViewerAppView;
    CleanupStack::PushL( self );
    self->ConstructL( aRect );
    return self;
    }

// -----------------------------------------------------------------------------
// CTxtViewerAppView::ConstructL()
// Symbian 2nd phase constructor can leave.
// -----------------------------------------------------------------------------
//
void CTxtViewerAppView::ConstructL( const TRect& /*aRect*/ )
    {
    }

// -----------------------------------------------------------------------------
// CTxtViewerAppView::LoadBodyL()
// Load message body to the editor.
// -----------------------------------------------------------------------------
//

void CTxtViewerAppView::LoadBodyL()
	{
	TMsvId id= EntryId();
	
	// Switch context 
	iClientMtm->SwitchCurrentEntryL(id);
		
	// Set state to editing
	iStore=iClientMtm->Entry().EditStoreL();

	// Get editor's CRichBox object
    CRichText* body = iEditor->RichText();

	// Restore CRichText to body
	iStore->RestoreBodyTextL(*body);
	
	
	delete iStore;
	iStore = NULL;
	    
    iEditor->HandleTextChangedL();
	}
// -----------------------------------------------------------------------------
// CTxtViewerAppView::SaveBodyL()
// Saves message body to the stream.
// -----------------------------------------------------------------------------
//

void CTxtViewerAppView::SaveBodyL()
	{
	TMsvId id= EntryId();

	// Switch context 
	iClientMtm->SwitchCurrentEntryL(id);
		
	// Set state to editing
	iStore=iClientMtm->Entry().EditStoreL();

	// Get editor's CRichBox object
    CRichText* text = iEditor->RichText();

//    _LIT(KText,"some message text");

//    text->InsertL(0,KText);

	// Store CRichText in body
	iStore->StoreBodyTextL(*text);

	iStore->CommitL();
	
	delete iStore;

	iStore=NULL;
	}

// -----------------------------------------------------------------------------
// CTxtViewerAppView::CTxtViewerAppView()
// C++ default constructor can NOT contain any code, that might leave.
// -----------------------------------------------------------------------------
//
CTxtViewerAppView::CTxtViewerAppView()
    {
    // No implementation required
    }


// -----------------------------------------------------------------------------
// CTxtViewerAppView::OfferKeyEventL
// Pass key events to the editor
// -----------------------------------------------------------------------------
//
TKeyResponse CTxtViewerAppView::OfferKeyEventL( const TKeyEvent& aKeyEvent, 
                                                  TEventCode aType )
    {
    // Redirect keyevents to controls
    if ( iEditor ) 
        {
        return iEditor->OfferKeyEventL( aKeyEvent, aType );
        }

    return EKeyWasNotConsumed;
    }


TMsvId CTxtViewerAppView::EntryId() 
	{
	
	// Get Id from the document
	CEikonEnv* env = CEikonEnv::Static();
	
	CTxtViewerAppUi* appui = static_cast<CTxtViewerAppUi*>(env->AppUi());
	
	CTxtViewerDocument* doc = appui->Document();
	
	return doc->Id();
	
	}
	
TBool CTxtViewerAppView::OpenedForEditing() 
	{
	// Get Id from the document
	CEikonEnv* env = CEikonEnv::Static();
	
	CTxtViewerAppUi* appui = static_cast<CTxtViewerAppUi*>(env->AppUi());
	
	CTxtViewerDocument* doc = appui->Document();
	
	return doc->OpenedForEditing();
		
	}
		

void CTxtViewerAppView::InitializeMTMsL()
	{
			

	// Create a session to the message server
	iSession = CMsvSession::OpenSyncL(iOb);
	//CleanupStack::PushL(session);

	// Get ui and client registries
	iClientReg = CClientMtmRegistry::NewL(*iSession);	
	
	iUiReg = CMtmUiRegistry::NewL(*iSession);	

	// Check if that type is available otherwise leave
	if(!iClientReg->IsPresent(KUidMsgTypeText))	User::Leave(KErrNotFound);
	
	// try to create ui mtm and client mtm instances
	iClientMtm = (CTextMtmClient*)iClientReg->NewMtmL(KUidMsgTypeText);
	
	iUiMtm = (CTextMtmUi*)iUiReg->NewMtmUiL(*iClientMtm );
	
	TMsvId id= EntryId();
	
	// Switch context 
	iClientMtm->SwitchCurrentEntryL(id);
		
	// Set state to editing
	iStore=iClientMtm->Entry().EditStoreL();
	
	
	// Create a body for the message if body is missing
	if (!iStore->HasBodyTextL())
		{
		// Create CRichText object
		CRichText* body = CRichText::NewL(iEikonEnv->SystemParaFormatLayerL(), 
			iEikonEnv->SystemCharFormatLayerL());
		CleanupStack::PushL(body);

		// Store CRichText in body
		iStore->StoreBodyTextL(*body);
		iStore->CommitL();
	
		CleanupStack::PopAndDestroy(); // body
		}

	delete iStore;
	iStore=NULL;
	}

// -----------------------------------------------------------------------------
// CTxtViewerAppView::~CTxtViewerAppView()
// Destructor.
// -----------------------------------------------------------------------------
//
CTxtViewerAppView::~CTxtViewerAppView()
    {
	delete iStore;
	delete iClientMtm; 
	delete iUiMtm;
  	delete iUiReg;
  	delete iClientReg; 
   	delete iSession;
   	
   	
    }

// -----------------------------------------------------------------------------
// CTxtViewerAppView::Draw()
// Draws the display.
// -----------------------------------------------------------------------------
//
void CTxtViewerAppView::Draw( const TRect& /*aRect*/ ) const
    {
  	}

// -----------------------------------------------------------------------------
// CTxtViewerAppView::SizeChanged()
// Called by framework when the view size is changed.
// -----------------------------------------------------------------------------
//
void CTxtViewerAppView::SizeChanged()
    {  
    TRect rect;
	
	AknLayoutUtils::LayoutMetricsRect( AknLayoutUtils::EMainPane, rect );

	iEditor->SetRect( TRect( TPoint(0,0),rect.Size()) );
    
    DrawNow();
    }

void CTxtViewerAppView::ExportToFileL( const TDes& aFileName )
    {
    RFileWriteStream myFileWriteStream;
    
    myFileWriteStream.Open(  CCoeEnv::Static()->FsSession(), aFileName , EFileWrite );

    myFileWriteStream.PushL();

    // Get editor's CRichBox object
    CRichText* text = iEditor->RichText();

    text->ExternalizePlainTextL( myFileWriteStream );

    myFileWriteStream.CommitL();

    myFileWriteStream.Close();

    myFileWriteStream.Pop();
    }
// End of File
