// Copyright (c) 1997-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Header file for EIKON interface to ECHOENG
//

#include <basched.h>
#include <eikenv.h>
#include <coecntrl.h>
#include <eikappui.h>
#include <e32keys.h>
#include <eikconso.h>
#include <eikapp.h>
#include <eikdoc.h>
#include <eikon.rsg>
#include <eikinfo.h>
//#include <eikcmds.hrh>
#include <eikon.hrh>//newly added
#include <eikecho.rsg>
#include "ECHOENG.H"

#ifndef _EIKECHO_H_
#define _EIKECHO_H_



const TUid KUidEikEchoApp = {0xE800006A};

// Connection values: substitute alternative values for KInetAddr
// and KInetHostName if you want to use different servers
const TUint32 KInetAddr = INET_ADDR(10,159,34,198);//(193,63,255,1); //
_LIT(KInetHostName,"phoenix.doc.ic.ac.uk");

// Integer formatting descriptor
_LIT(KIntFormat,"%d");


//
// CConsoleControl: console-type control
//

class CConsoleControl : public CCoeControl, public MUINotify
	{
public:
	static CConsoleControl* NewL(CEchoEngine* aEchoEngine);
	~CConsoleControl();
	void ConstructL(CEchoEngine* aEchoEngine);

	// Override CCoeControl
    TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);
    void ActivateL();

	//Implement MUINotify up calls
	void PrintNotify(const TDesC& aDes);
	void PrintNotify(TInt aInt);
	void ErrorNotifyL(const TDesC& aErrMessage, TInt aErrCode);
protected:
	CConsoleControl() {}
private:
	CEikConsoleScreen* iConsole;	// Standard EIKON console control
	CEchoEngine* iEchoEngine;		// The echo engine
	};

//
// CEchoAppUi: user interface command handling
//

class CEchoAppUi : public CEikAppUi
    {
public:
	CEchoAppUi(CEchoEngine* aEchoEngine);
    void ConstructL();
	void CreateConsoleL();
	~CEchoAppUi();
private:
	// Override CEikAppUi
    void HandleCommandL(TInt aCommand);
private:
	CConsoleControl* iConsoleControl;
	CEchoEngine* iEchoEngine;
	};

//
// CEchoDocument: document class, which owns the engine
//

class CEchoDocument : public CEikDocument
	{
public:
	CEchoDocument(CEikApplication& aApp);
	static CEchoDocument* NewL(CEikApplication& aApp);
	~CEchoDocument();
	void ConstructL();
private:
	// Override CApaDocument
	CEikAppUi* CreateAppUiL();
private:
	CEchoEngine* iEchoEngine; // Document owns the echo engine
	};

//
// CEchoApplication
//

class CEchoApplication : public CEikApplication
	{
private: // from CApaApplication
	CApaDocument* CreateDocumentL();
	TUid AppDllUid() const;
	};
#endif



