// Copyright (c) 2000-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef __NOTIFY_H
#define __NOTIFY_H

#include "CommonFramework.h"
#include <f32file.h>
	
/** 
	Monitors file copy events, and prints out the progress.
*/
class TFileCopyProgressMonitor : public MFileManObserver
	{
public:
	/** 
		Constructor.
		@param aFileMan Used to obtain the number of bytes currently copied 
	*/
	TFileCopyProgressMonitor(CFileMan& aFileMan);
private:
	TControl NotifyFileManStarted();
	TControl NotifyFileManOperation();
	TControl NotifyFileManEnded();	
private:
	CFileMan& iFileMan;
	};

#endif
