/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef DESCRIPTOREXAPPUI_H
#define DESCRIPTOREXAPPUI_H

#include <eikapp.h>
#include <eikdoc.h>
#include <e32std.h>
#include <coeccntx.h>
#include <aknappui.h>
#include "DescriptorExamples.h"

class CDescriptorExContainer;

class CDescriptorExAppUi : public CAknAppUi, public MResultViewer
    {
    public:
        void ConstructL();
        ~CDescriptorExAppUi();

    private:
        /**
        * Run all example methods and write results to file.
        */
        void RunAllL();

        TKeyResponse HandleKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);

        /**
        * From CEikAppUi, takes care of command handling.
        * @param aCommand command to be handled
        */
        void HandleCommandL(TInt aCommand);

        /**
        * From MResultViewer, returns buffer where examples can render*
        * results.
        */
        TPtr GetViewBuffer();
        
        /**
        * From MResultViewer, updates the editor window with content written
        * by example methods. Internal buffer is cleared so next call to
        * method GetViewBuffer() does return an empty buffer.
        */
        void UpdateView();
        
        void HandleResourceChangeL(TInt aType);

    private:
        CDescriptorExContainer* iAppContainer;
        CDescriptorExamples* iExamples;
        HBufC *iBuffer;
    };

#endif
