/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef DESCRIPTOREXCONTAINER_H
#define DESCRIPTOREXCONTAINER_H

#include <eikedwin.h>

class CAknsBasicBackgroundControlContext;

class CDescriptorExContainer : public CCoeControl
    {
    public:

        /**
        * Constructs a container containing a one non writable CEikEdwin editor
        * component.
        * @param drawArea rectangle where this container is allowed to
        *        draw its controls
        */
        void ConstructL(const TRect& aRect);

        /**
        * Destroys this container and owned editor.
        */
        ~CDescriptorExContainer();

        /**
        * Updates the efitor component with given text and sets the focus on
        * editor.
        */
        void SetTextL( const TDesC& aText );

    public: // overriden methods of CCoeControl

        /**
        * Processes cursor key presses so that cursor moves in editor component.
        */
        virtual TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent,
                                            TEventCode aType);
        void SizeChanged();

    private: // overriden methods of CCoeControl

        /**
        * Returns the number of components this container owns (that is one
        * since only CEikEdwin control is used at this time).
        */
        TInt CountComponentControls() const;
        CCoeControl* ComponentControl(TInt aIndex) const;

        TTypeUid::Ptr MopSupplyObject(TTypeUid aId);
        
    private:
        TInt GetScrollbarWidth() const;

    private:
        CEikEdwin*                          iTextBox;
        CAknsBasicBackgroundControlContext* iSkinContext;
    };

#endif
