/*
 * Copyright  2008 Nokia Corporation.
 */

#include "DescriptorExDocument.h"
#include "DescriptorExAppUi.h"

// -----------------------------------------------------------------------------
// Constructor. No data to hold, empty implementation.
// -----------------------------------------------------------------------------
CDescriptorExDocument::CDescriptorExDocument(CEikApplication& aApp)
: CAknDocument(aApp)    
    {
    }

// -----------------------------------------------------------------------------
// Destructor. Nothing to do since an empty document.
// -----------------------------------------------------------------------------
CDescriptorExDocument::~CDescriptorExDocument()
    {
    }

// -----------------------------------------------------------------------------
// Second phase constructor. Nothing to do since empty implementation.
// -----------------------------------------------------------------------------
void CDescriptorExDocument::ConstructL()
    {
    }

// -----------------------------------------------------------------------------
// Factory method to construct an instance of CDescriptorExDocument. Returns
// an empty document.
// -----------------------------------------------------------------------------
CDescriptorExDocument* CDescriptorExDocument::NewL(
        CEikApplication& aApp)     // CDescriptorExApp reference
    {
    CDescriptorExDocument* self = new (ELeave) CDescriptorExDocument( aApp );
    CleanupStack::PushL( self );
    self->ConstructL();
    CleanupStack::Pop();

    return self;
    }
    
// -----------------------------------------------------------------------------
// This document returns instance of CDescriptorExAppUi for the framework.
// -----------------------------------------------------------------------------
CEikAppUi* CDescriptorExDocument::CreateAppUiL()
    {
    return new (ELeave) CDescriptorExAppUi;
    }
