/*
 * Copyright  2008 Nokia Corporation.
 */

#include <e32base.h>
#include <e32cons.h>
#include <e32std.h>
#include <f32file.h>
#include "DescriptorExamples.h"

// -----------------------------------------------------------------------------
// @see documentation from the header file "DescriptorExamples.h".
// -----------------------------------------------------------------------------
void CFileForwarder::ConstructL(const TDesC &logFileName)
    {
    iBuf = HBufC::NewL( 4096 );

    int pos = logFileName.LocateReverse( '\\' );
    TPtrC dirName = logFileName.Left( pos+1 );

    User::LeaveIfError(iFsSession.Connect()); // connect session
    iFsSession.MkDirAll(dirName);

    if( iFile.Open(iFsSession,logFileName,EFileWrite|EFileStreamText)
         == KErrNone )
        {
        // go to the end of the file
        TInt tmp = 0;
        iFile.Seek(ESeekEnd, tmp);
        } else
        {
        // file doesn't exist, create a new
        User::LeaveIfError(iFile.Replace(iFsSession,logFileName,
                                         EFileWrite|EFileStreamText));
        }
    }

// -----------------------------------------------------------------------------
// @see documentation from the header file "DescriptorExamples.h".
// -----------------------------------------------------------------------------
TPtr CFileForwarder::GetViewBuffer()
    {
    return iBuf->Des();
    }

// -----------------------------------------------------------------------------
// @see documentation from the header file "DescriptorExamples.h".
// -----------------------------------------------------------------------------
void CFileForwarder::UpdateView()
    {
    TPtrC8 representation((TUint8*)iBuf->Ptr(), iBuf->Size());
    iFile.Write(representation);
    iFile.Flush();

    iBuf->Des().SetLength( 0 );
    }

// -----------------------------------------------------------------------------
// @see documentation from the header file "DescriptorExamples.h".
// -----------------------------------------------------------------------------
CFileForwarder::~CFileForwarder()
    {
    iFile.Close();
    iFsSession.Close();
    delete iBuf;
    }
