// Copyright (c) 2000-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//


#include <f32file.h>
#include "CommonFramework.h"
	
static RFs fsSession;

// example functions
void CreatePathsL(); // sets up the paths to parse
void ParseNamesL(const TDesC& aFullName); // does the parsing

void WaitForKey()
	{
	_LIT(KMessage,"Press any key to continue\n\n");
	console->Printf(KMessage);
	console->Getch();
	}

static void doExampleL()
    {
	// Connect to file server
	User::LeaveIfError(fsSession.Connect()); // Start session
	CreatePathsL();
	fsSession.Close(); // close session
	}

void CreatePathsL()
	{
	// Define descriptor constants using the _LIT macro 
	_LIT(KFuncName,"\nDoParsing()\n");
	_LIT(KParse1,"d:\\path\\fn.ext");
	_LIT(KParse2,"autoexec.bat");
	_LIT(KParse3,"\\readme");
	_LIT(KParse4,"\\include\\stdio.h");
	_LIT(KParse5,".profile");
	_LIT(KParse6,"autoexec.*");
	console->Printf(KFuncName);
	// Parse a full path, then paths with various components missing 
	// to show the results of using a default path and related path
	// to fill in missing path components.
	ParseNamesL(KParse1);
	WaitForKey();
	ParseNamesL(KParse2);
	WaitForKey();
	ParseNamesL(KParse3);
	WaitForKey();
	ParseNamesL(KParse4);
	WaitForKey();
	ParseNamesL(KParse5);
	WaitForKey();
	ParseNamesL(KParse6);
	WaitForKey();
	}

void ParseNamesL(const TDesC& aFullName)
	{
	_LIT(KFullName,"Full name=%S\n");
	_LIT(KPathComponents,"Drive=%S  path=%S  name=%S  ext=%S\n");
	_LIT(KFullNameText,"Full name against session path=%S\n");
	_LIT(KExtension,".txt");
	_LIT(KParsedPath,"Full name against session path and default extension=%S\n");

	// Set up parse using TParse::Set(). Print whole path, then each path
	// component in turn.
	// Parse path using the default session path, using RFs::Parse 
	// then additionally with a related path.
	TParse p;
	// do isolated parse
	User::LeaveIfError(p.Set(aFullName,NULL,NULL));
	console->Printf(KFullName, &p.FullName());
	TFileName drivename(p.Drive());
	TFileName pathname(p.Path());
	TFileName filename(p.Name());
	TFileName extension(p.Ext());
	console->Printf(KPathComponents,&drivename,&pathname,&filename,&extension);
	// do parse including session path
	User::LeaveIfError(fsSession.Parse(aFullName,p));
	console->Printf(KFullNameText,&(p.FullName()));
	// add default extension
	User::LeaveIfError(fsSession.Parse(aFullName,KExtension,p));
	console->Printf(KParsedPath,&(p.FullName()));
	}




