/*
 * Copyright  2008 Nokia Corporation.
 */



#ifndef __LOCALIZATIONAPPLICATION_H__
#define __LOCALIZATIONAPPLICATION_H__

// INCLUDES
#include <aknapp.h>

// CLASS DECLARATION

/**
* CLocalizationApplication application class.
* Provides factory to create concrete document object.
* An instance of CLocalizationApplication is the application part of the
* AVKON application framework for the Localization example application.
*/
class CLocalizationApplication : public CAknApplication
    {
    public: // Functions from base classes

        /**
        * From CApaApplication, AppDllUid.
        * @return Application's UID (KUidLocalizationApp).
        */
        TUid AppDllUid() const;

    protected: // Functions from base classes

        /**
        * From CApaApplication, CreateDocumentL.
        * Creates CLocalizationDocument document object. The returned
        * pointer in not owned by the CLocalizationApplication object.
        * @return A pointer to the created document object.
        */
        CApaDocument* CreateDocumentL();
    };

#endif // __LOCALIZATIONAPPLICATION_H__

// End of File