/*
 * Copyright  2008 Nokia Corporation.
 */



// INCLUDE FILES
#include "LocalizationDocument.h"
#include "LocalizationApplication.h"

// ============================ MEMBER FUNCTIONS ===============================

// UID for the application;
const TUid KUidLocalizationApp = { 0xE0005B00 };

// -----------------------------------------------------------------------------
// CLocalizationApplication::CreateDocumentL()
// Creates CApaDocument object
// -----------------------------------------------------------------------------
//
CApaDocument* CLocalizationApplication::CreateDocumentL()
    {
    // Create an Localization document, and return a pointer to it
    return (static_cast<CApaDocument*>
                    ( CLocalizationDocument::NewL( *this ) ) );
    }

// -----------------------------------------------------------------------------
// CLocalizationApplication::AppDllUid()
// Returns application UID
// -----------------------------------------------------------------------------
//
TUid CLocalizationApplication::AppDllUid() const
    {
    // Return the UID for the Localization application
    return KUidLocalizationApp;
    }

// End of File
