// Copyright (c) 2000-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Transient server example - test client implementation
//

#include <e32base.h>
#include <t-client.h>
#include "testclient.h"

class CMyClient : public CClient
	{
	IMPORT_C static CClient* NewL();
	~CMyClient();
 	TInt Send(const TDesC& aMessage);
	void Receive(TRequestStatus& aStatus,TDes& aMessage);
	void CancelReceive();
private:
	RMySession iSession;
	};

EXPORT_C CClient* CMyClient::NewL()
	{
	CMyClient* self=new(ELeave) CMyClient;
	CleanupClosePushL(*self);
	User::LeaveIfError(self->iSession.Connect());
	CleanupStack::Pop();
	return self;
	}

CMyClient::~CMyClient()
	{
	iSession.Close();
	}

TInt CMyClient::Send(const TDesC& aMessage)
	{
	return iSession.Send(aMessage);
	}

void CMyClient::Receive(TRequestStatus& aStatus,TDes& aMessage)
	{
	iSession.Receive(aStatus,aMessage);
	}

void CMyClient::CancelReceive()
	{
	iSession.CancelReceive();
	}
