// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the E32Main() function, which executes the example.
// The example demonstrates the use of the TDblQue class, which represents
// a doubly linked list.
// The user enters a string, which is stored as linked list of characters
// of the string. The user can edit this string by adding characters to the
// string.
// The example displays the reverse of this string on the console.
//



/**
 @file
*/

#include "mystringreverse.h"

LOCAL_D CConsoleBase* console;

LOCAL_C void DoStartL();
LOCAL_C void CallExampleL();

LOCAL_C void DoStartL()
	{
	// Create and install the active scheduler.
	CActiveScheduler* scheduler = new (ELeave) CActiveScheduler();
	CleanupStack::PushL(scheduler);
	CActiveScheduler::Install(scheduler);

	_LIT(KTextDbllist,"Double Linked List Demo\nEnter the characters of the string\n");
	console->Printf(KTextDbllist);
	// Create an object of the CMyStringReverse class.
	CMyStringReverse* stringreverse = CMyStringReverse::NewL(console);
	CleanupStack::PushL(stringreverse);

	// Read the string from the user.
	// Generate an asynchronous read request.
	stringreverse->ReadOption();

	// Start the active scheduler.
	CActiveScheduler::Start();

	// Destroy the objects in the cleanup stack.
	CleanupStack::PopAndDestroy(2, scheduler); // stringreverse, scheduler.
	}

GLDEF_C TInt E32Main() // main function called by E32
    {
	__UHEAP_MARK;
	CTrapCleanup* cleanup=CTrapCleanup::New(); // get clean-up stack
	TRAPD(error, CallExampleL()); // more initialization, then do example
	delete cleanup; // destroy clean-up stack
	__ASSERT_ALWAYS(!error, User::Panic(KTxtEPOC32EX, error));
	__UHEAP_MARKEND;
	return 0; // and return
    }

LOCAL_C void CallExampleL() // initialize and call example code under cleanup stack
    {
	console=Console::NewL(KTxtExampleCode, TSize(KConsFullScreen, KConsFullScreen));
	CleanupStack::PushL(console);
	TRAPD(error, DoStartL()); // perform example function
	if (error)
		console->Printf(KFormatFailed, error);
	else
		console->Printf(KTxtOK);
	console->Printf(KTextPressAnyKey);
	console->Getch(); // get and ignore character
	CleanupStack::PopAndDestroy(); // close console
    }
