// Copyright (c) 2006-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#include "BmpAnimGui.h"

// Second phase constructor of the application UI class.
// It creates and owns a single view.
void CExampleAppUi::ConstructL()
	{
	// Complete the UI framework's construction of the App UI.
	BaseConstructL();
   	// Create the appview.
	iAppView = CExampleAppView::NewL( ClientRect() );
	}

// The application UI class owns one view, and is responsible
// for destroying it
CExampleAppUi::~CExampleAppUi()
	{
	delete iAppView;
	}

// Called by the UI framework when a command has been issued.
void CExampleAppUi::HandleCommandL( TInt aCommand )
	{
	
	switch (aCommand)
		{
	case EGuiBaseDo0:
		iAppView->iBitmapAnimPlayer.SetPlayModeL( CBitmapAnimClientData::EPlay );
		iAppView->iBitmapAnimPlayer.StartL();		
		break;				 
	
	case EGuiBaseDo1:
	 	iAppView->iBitmapAnimPlayer.StopL();
		break;
	
	case EGuiBaseDo2:
		iAppView->iBitmapAnimPlayer.SetPlayModeL( CBitmapAnimClientData::EBounce );
		iAppView->iBitmapAnimPlayer.StartL();
		break;
		
	case EGuiBaseDo3:
		iAppView->iBitmapAnimPlayer.SetPlayModeL( CBitmapAnimClientData::ECycle );
		iAppView->iBitmapAnimPlayer.StartL();
		break;

	case EEikCmdExit: 
		Exit();
		break;
		}
	
	}

