/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef IMAGECONVERTERCONTAINER_H
#define IMAGECONVERTERCONTAINER_H

// INCLUDES
#include <coecntrl.h>

#ifdef __TUI_SUPPORTED__
#include <touchfeedback.h>
#include <touchlogicalfeedback.h>
#include <aknlongtapdetector.h> 
#endif

// Minium amount of pointer drag events received
const TInt KMIN_POINTER_COUNT = 10;

#define DELAY 30000
#define SLEEP_DELAY 1*1000*1000


// FORWARD DECLARATIONS
class CEikLabel;        // for example labels
class CImageConverterAppUi;

enum EPointerEvents
    {
    ENoValidPointerEvent = 0,
    EZoomIn,
    EZoomOut,
    ENextImage,
    EPrevImage,
    ERotateRight,
    ERotateLeft
    };

enum ETitleState
    {
    ETitleNo = 0,
    ETitleZoomIn,
    ETitleZoomOut,
    ETitleNextImage,
    ETitlePrevImage,
    ETitleRotateRight,
    ETitleRotateLeft
    };

enum EAnimationEvents
    {
    ENoAnimation = 0,
    EAnimateToRight,
    EAnimateToLeft,
    EAnimateFromRight,
    EAnimateFromLeft
    };

// CLASS DECLARATION

/**
*  CImageConverterContainer  container control class.
*  
*/
class CImageConverterContainer : public CCoeControl, 
MCoeControlObserver
#ifdef __TUI_SUPPORTED__
, MAknLongTapDetectorCallBack
#endif    
    {
    public: // Constructors and destructor
        
        /**
        * EPOC default constructor.
        * @param aRect Frame rectangle for container.
        */
        void ConstructL(const TRect& aRect);

        /**
        * Destructor.
        */
        ~CImageConverterContainer();

    public: // New functions
        void SetBitmap(CFbsBitmap* aBitmap);
        void StartAnimateL();
        void StartNewPictureAnimate();
        TBool IsAnimating();
        void SetNextAnimationWaiting(TBool aValue);

        void ChangeNextPictureL();
        void ChangePrevPictureL();
        void SetPictureScreenCenter(TBool aDraw);
        
    public:
        void DrawToBackBuffer();
        void SetTitleText(ETitleState aState, TBool aDrawNow);
        void ResetTitleText(TBool aDrawNow);

    private:

        /**
        * From CoeControl,SizeChanged.
        */
        void SizeChanged();

        /**
        * From CoeControl,HandleResourceChange.
        */
        void HandleResourceChange(TInt aType);

        /**
        * From CoeControl,CountComponentControls.
        */
        TInt CountComponentControls() const;

        /**
        * From CCoeControl,ComponentControl.
        */
        CCoeControl* ComponentControl(TInt aIndex) const;

        /**
        * From CCoeControl,Draw.
        */
        void Draw(const TRect& aRect) const;
        
        /**
        * From MCoeControlObserver
        * Acts upon changes in the hosted control's state. 
        *
        * @param    aControl    The control changing its state
        * @param    aEventType  The type of control event 
        */
        void HandleControlEventL(CCoeControl* aControl,TCoeEvent aEventType);
        
        #ifdef __TUI_SUPPORTED__
        void HandlePointerEventL(const TPointerEvent& aPointerEvent);
        void MovePicture(const TPoint& aPoint);        
        #endif
        
        TBool IsZooming();

        TBool IsChangingPicture();
        
        TBool IsRotate();

        TPoint FindCenterPointInRotate(TPoint& aFirstPoint);
        
        void FindPointsForRotate(TPoint& aTopPoint, TPoint& aCenterPoint, TPoint& aBottomPoint, TBool& aDrawDirectionIsFromTop);

        void StopAnimate();

        static TInt Animate(TAny* aObj);
        static TInt Sleep(TAny* aObj);
        
        void DoFrame();
        
        void CreateBackBufferL();
        void ReleaseBackBuffer();
        
        
        

    #ifdef __TUI_SUPPORTED__    
    private: // From MAknLongTapDetectorCallBack
        void HandleLongTapEventL( const TPoint& aPenEventLocation, const TPoint& aPenEventScreenLocation );
    #endif        

    private: //data
       CFbsBitmap*          iBitmap;        
       TPoint               iPicturePoint;
       TBuf<100>            iPictureInfo;
       TBuf<100>            iStateInfo;
       CFont*               iFont;
       CFont*               iCbaFont;

       // Pointer events
       RArray<TPoint>       iDragPoints;
       EPointerEvents       iPointerEvent;

       // Animation
       CPeriodic*           iPeriodic; 
       TInt                 iAnimateX;
       TInt                 iPixelsToMove;
       TBool                iNextAnimationWaiting;
       EAnimationEvents     iAnimationEvent;

       #ifdef __TUI_SUPPORTED__       
       // Long tap detection
       CAknLongTapDetector* iLongTapDetector;
       TBool                iLongTapDetected;
       TPoint               iLongTapPoint;
       
       MTouchFeedback*      iTouchFeedBack;
       #endif       
       
       CImageConverterAppUi*            iAppUi;
       
       TRect                            iOptionsRect;
       TRect                            iExitRect;

       // double buffer bitmapsystem
       CFbsBitmap*                      iBackBuffer;
       CFbsBitmapDevice*                iBackBufferDevice;
       CFbsBitGc*                       iBackBufferContext;
       TSize                            iBackBufferSize;
       
       ETitleState                      iTitleState;
    };

#endif

// End of File
