/*
 * Copyright  2008 Nokia Corporation.
 */

// INCLUDE FILES
#include <ImageConversion.h>
#include "ShowInfoDialog.h"

const TInt KMaxInfoDescriptorLength = 100;

CShowInfoDialog::CShowInfoDialog( CFrameInfoStrings* aInfoStrings ) : 
    iInfoStrings( aInfoStrings )
    {
    }

CShowInfoDialog::~CShowInfoDialog()
    {
    iEikonEnv->ScreenDevice()->ReleaseFont(iFont);
    }

void CShowInfoDialog::PreLayoutDynInitL()
    {
    CAknQueryDialog::PreLayoutDynInitL();
    SetEditableL(ETrue);    
    
    // Create font
    _LIT( KSeries60SansB, "Series 60 SansB" );
    TFontSpec fontSpec( KSeries60SansB, 75 );
    fontSpec.iFontStyle.SetBitmapType(EAntiAliasedGlyphBitmap);
    User::LeaveIfError(iEikonEnv->ScreenDevice()->GetNearestFontInTwips( iFont, fontSpec ));
    }

void CShowInfoDialog::PostLayoutDynInitL()
    {
    CalculatePositionAndSize();
    }

TBool CShowInfoDialog::OkToExitL(TInt /*aButtonId*/)
    {
    return ETrue;
    }

TInt CShowInfoDialog::CountComponentControls() const
    {
    return( 0 ); 
    }

CCoeControl* CShowInfoDialog::ComponentControl(TInt /*aIndex*/) const
    {
    return NULL;
    }

void CShowInfoDialog::CalculatePositionAndSize()
    {
    TRect cRect;
    AknLayoutUtils::LayoutMetricsRect(AknLayoutUtils::EMainPane,cRect);
    
    cRect.Shrink(25,25);
    SetExtent(cRect.iTl,cRect.Size());
    }

void CShowInfoDialog::SetSizeAndPosition(const TSize &aSize)
    {
    CAknQueryDialog::SetSizeAndPosition( aSize );
    
    CalculatePositionAndSize();
    }

void CShowInfoDialog::SizeChanged()
    {
    DrawNow();
    }

void CShowInfoDialog::HandleResourceChange(TInt aType)
    {
    CAknQueryDialog::HandleResourceChange(aType);   
    }

void CShowInfoDialog::Draw( const TRect& /*aRect*/ ) const
    {
    // Get the standard graphics context
    CWindowGc& gc = SystemGc();
    gc.SetPenStyle( CGraphicsContext::ENullPen );
    gc.SetBrushColor( KRgbBlack);
    gc.SetBrushStyle( CGraphicsContext::ESolidBrush );

    // Clear screen
    gc.Clear(Rect());
    gc.SetBrushStyle( CGraphicsContext::ENullBrush );
    
    // Draw round rect
    gc.SetPenStyle( CGraphicsContext::ESolidPen );
    gc.SetPenColor(KRgbWhite);
    gc.DrawRect(Rect());

    // Draw image info texts
    gc.UseFont(iFont);
    TBuf<KMaxInfoDescriptorLength> desc;
    TPoint point = Rect().iTl;
    point.iX += 10;
    for( TInt i=0; i<iInfoStrings->Count(); i++ ) 
        {
        point.iY += 20;
        desc.Copy( iInfoStrings->String(i) );
        gc.DrawText(desc,point);
        }
    }




