/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.DefaultEncodingSupport;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class TextEditor
extends AbstractDecoratedTextEditor {
    protected DefaultEncodingSupport fEncodingSupport;
    static /* synthetic */ Class class$0;

    public TextEditor() {
        if (this.getSourceViewerConfiguration() == null) {
            this.setSourceViewerConfiguration(new TextSourceViewerConfiguration(this.getPreferenceStore()));
        }
    }

    protected void initializeEditor() {
        this.setEditorContextMenuId("#TextEditorContext");
        this.setRulerContextMenuId("#TextRulerContext");
        this.setHelpContextId("org.eclipse.ui.text_editor_context");
        this.setPreferenceStore(EditorsPlugin.getDefault().getPreferenceStore());
        this.configureInsertMode(SMART_INSERT, false);
        this.setInsertMode(INSERT);
    }

    public void dispose() {
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.dispose();
            this.fEncodingSupport = null;
        }
        super.dispose();
    }

    protected void installEncodingSupport() {
        this.fEncodingSupport = new DefaultEncodingSupport();
        this.fEncodingSupport.initialize(this);
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        String key = String.valueOf(this.getEditorSite().getId()) + ".internal.delegateSaveAs";
        store.setValue(key, true);
        super.performSaveAs(progressMonitor);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void createActions() {
        this.installEncodingSupport();
        super.createActions();
    }

    protected String getStatusHeader(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusHeader(status)) != null) {
            return message;
        }
        return super.getStatusHeader(status);
    }

    protected String getStatusBanner(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusBanner(status)) != null) {
            return message;
        }
        return super.getStatusBanner(status);
    }

    protected String getStatusMessage(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusMessage(status)) != null) {
            return message;
        }
        return super.getStatusMessage(status);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.editors.text.IEncodingSupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.fEncodingSupport;
        }
        return super.getAdapter(adapter);
    }

    protected void updatePropertyDependentActions() {
        super.updatePropertyDependentActions();
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.edit", "ShiftRight");
        this.addAction(menu, "group.edit", "ShiftLeft");
    }
}

