/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.stub;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.jmock.core.CoreMock;
import org.jmock.core.Formatting;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;

public class DefaultResultStub
implements Stub {
    private Map resultValuesByType = new HashMap();

    public DefaultResultStub() {
        this.createDefaultResults();
    }

    public StringBuffer describeTo(StringBuffer buf) {
        return buf.append("returns a default value");
    }

    public void addResult(Class resultType, Object resultValue) {
        this.resultValuesByType.put(resultType, resultValue);
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Class<?> returnType = invocation.invokedMethod.getReturnType();
        if (this.resultValuesByType.containsKey(returnType)) {
            return this.resultValuesByType.get(returnType);
        }
        if (returnType.isArray()) {
            return Array.newInstance(returnType.getComponentType(), 0);
        }
        if (returnType.isInterface()) {
            CoreMock nullMock = new CoreMock(returnType, "null" + Formatting.classShortName(returnType));
            nullMock.setDefaultStub(this);
            return nullMock.proxy();
        }
        throw new AssertionFailedError(this.createErrorMessage(invocation));
    }

    public String createErrorMessage(Invocation call) {
        StringBuffer buf = new StringBuffer();
        buf.append("unexpected result type: ");
        buf.append(call.invokedMethod.getReturnType().toString());
        buf.append("\n");
        if (this.resultValuesByType.isEmpty()) {
            buf.append("no result types are registered!");
        } else {
            buf.append("expected one of: ");
            Iterator i = this.resultValuesByType.keySet().iterator();
            boolean separatorRequired = false;
            while (i.hasNext()) {
                if (separatorRequired) {
                    buf.append(", ");
                }
                buf.append(((Class)i.next()).getName());
                separatorRequired = true;
            }
        }
        return buf.toString();
    }

    protected void createDefaultResults() {
        this.addResult(Boolean.TYPE, Boolean.FALSE);
        this.addResult(Void.TYPE, null);
        this.addResult(Byte.TYPE, new Byte(0));
        this.addResult(Short.TYPE, new Short(0));
        this.addResult(Integer.TYPE, new Integer(0));
        this.addResult(Long.TYPE, new Long(0L));
        this.addResult(Character.TYPE, new Character('\u0000'));
        this.addResult(Float.TYPE, new Float(0.0f));
        this.addResult(Double.TYPE, new Double(0.0));
        this.addResult(Boolean.class, Boolean.FALSE);
        this.addResult(Byte.class, new Byte(0));
        this.addResult(Short.class, new Short(0));
        this.addResult(Integer.class, new Integer(0));
        this.addResult(Long.class, new Long(0L));
        this.addResult(Character.class, new Character('\u0000'));
        this.addResult(Float.class, new Float(0.0f));
        this.addResult(Double.class, new Double(0.0));
        this.addResult(String.class, "");
        this.addResult(Object.class, new Object());
    }
}

