/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.CommonContentExtensionSite;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.SafeDelegateCommonLabelProvider;
import org.eclipse.ui.internal.navigator.extensions.SafeDelegateTreeContentProvider;
import org.eclipse.ui.internal.navigator.extensions.SkeletonLabelProvider;
import org.eclipse.ui.internal.navigator.extensions.SkeletonTreeContentProvider;
import org.eclipse.ui.internal.navigator.extensions.StructuredViewerManager;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.IMementoAware;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentExtension;

public class NavigatorContentExtension
implements IMementoAware,
INavigatorContentExtension {
    private static final NavigatorContentExtension[] NO_EXTENSIONS = new NavigatorContentExtension[0];
    private NavigatorContentService contentService;
    private NavigatorContentDescriptor descriptor;
    private ICommonContentProvider contentProvider;
    private ICommonLabelProvider labelProvider;
    private boolean labelProviderInitializationFailed = false;
    private boolean contentProviderInitializationFailed = false;
    private boolean isDisposed = false;
    private IMemento appliedMemento;
    private StructuredViewerManager viewerManager;

    public NavigatorContentExtension(NavigatorContentDescriptor aDescriptor, NavigatorContentService aContentService, StructuredViewerManager aViewerManager) {
        Assert.isNotNull((Object)aDescriptor);
        this.descriptor = aDescriptor;
        this.contentService = aContentService;
        this.viewerManager = aViewerManager;
    }

    public String getId() {
        return this.descriptor.getId();
    }

    public INavigatorContentDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ITreeContentProvider getContentProvider() {
        ITreeContentProvider provider = this.internalGetContentProvider();
        if (provider != SkeletonTreeContentProvider.INSTANCE) {
            return ((SafeDelegateTreeContentProvider)provider).getDelegateContentProvider();
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITreeContentProvider internalGetContentProvider() {
        if (this.contentProvider != null || this.contentProviderInitializationFailed) {
            return this.contentProvider;
        }
        NavigatorContentExtension navigatorContentExtension = this;
        synchronized (navigatorContentExtension) {
            try {
                if (this.contentProvider == null) {
                    ITreeContentProvider treeContentProvider = this.descriptor.createContentProvider();
                    if (treeContentProvider != null) {
                        this.contentProvider = new SafeDelegateTreeContentProvider(treeContentProvider, this.descriptor, this.contentService);
                        this.contentProvider.init(new CommonContentExtensionSite(this.getId(), this.contentService, this.appliedMemento));
                        this.viewerManager.initialize((IStructuredContentProvider)this.contentProvider);
                    } else {
                        this.contentProvider = SkeletonTreeContentProvider.INSTANCE;
                    }
                }
            }
            catch (CoreException e) {
                this.contentProviderInitializationFailed = true;
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                this.contentProviderInitializationFailed = true;
                e.printStackTrace();
            }
            if (this.contentProviderInitializationFailed) {
                this.contentProvider = SkeletonTreeContentProvider.INSTANCE;
            }
        }
        return this.contentProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommonLabelProvider getLabelProvider() {
        if (this.labelProvider != null || this.labelProviderInitializationFailed) {
            return this.labelProvider;
        }
        NavigatorContentExtension navigatorContentExtension = this;
        synchronized (navigatorContentExtension) {
            try {
                if (this.labelProvider == null) {
                    ILabelProvider tempLabelProvider = this.descriptor.createLabelProvider();
                    if (tempLabelProvider instanceof ICommonLabelProvider) {
                        this.labelProvider = (ICommonLabelProvider)tempLabelProvider;
                        this.labelProvider.init(new CommonContentExtensionSite(this.getId(), this.contentService, this.appliedMemento));
                    } else {
                        this.labelProvider = new SafeDelegateCommonLabelProvider(tempLabelProvider);
                    }
                    this.labelProvider.addListener((ILabelProviderListener)this.contentService.createCommonLabelProvider());
                }
            }
            catch (CoreException e) {
                this.labelProviderInitializationFailed = true;
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                this.labelProviderInitializationFailed = true;
                e.printStackTrace();
            }
            if (this.labelProviderInitializationFailed) {
                this.labelProvider = SkeletonLabelProvider.INSTANCE;
            }
        }
        return this.labelProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            NavigatorContentExtension navigatorContentExtension = this;
            synchronized (navigatorContentExtension) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        String msg = exception.getMessage() != null ? exception.getMessage() : exception.toString();
                        NavigatorPlugin.logError(0, msg, exception);
                    }

                    public void run() throws Exception {
                        if (NavigatorContentExtension.this.contentProvider != null) {
                            NavigatorContentExtension.this.contentProvider.dispose();
                        }
                    }
                });
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        String msg = exception.getMessage() != null ? exception.getMessage() : exception.toString();
                        NavigatorPlugin.logError(0, msg, exception);
                    }

                    public void run() throws Exception {
                        if (NavigatorContentExtension.this.labelProvider != null) {
                            NavigatorContentExtension.this.labelProvider.removeListener((ILabelProviderListener)NavigatorContentExtension.this.contentService.createCommonLabelProvider());
                            NavigatorContentExtension.this.labelProvider.dispose();
                        }
                    }
                });
            }
        }
        finally {
            this.isDisposed = true;
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean hasContentProviderInitializationFailed() {
        return this.contentProviderInitializationFailed;
    }

    public boolean hasLabelProviderInitializationFailed() {
        return this.labelProviderInitializationFailed;
    }

    public boolean hasLoadingFailed() {
        return this.contentProviderInitializationFailed;
    }

    public boolean isLoaded() {
        return this.contentProvider != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreState(IMemento aMemento) {
        NavigatorContentExtension navigatorContentExtension = this;
        synchronized (navigatorContentExtension) {
            this.appliedMemento = aMemento;
            this.applyMemento(this.contentProvider);
            this.applyMemento(this.labelProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(IMemento aMemento) {
        NavigatorContentExtension navigatorContentExtension = this;
        synchronized (navigatorContentExtension) {
            if (this.contentProvider != null && this.contentProvider instanceof IMementoAware) {
                this.contentProvider.saveState(aMemento);
            }
            if (this.labelProvider != null && this.labelProvider instanceof IMementoAware) {
                this.labelProvider.saveState(aMemento);
            }
        }
    }

    private void applyMemento(IMementoAware target) {
        if (target != null) {
            target.restoreState(this.appliedMemento);
        }
    }

    protected final void complainDisposedIfNecessary() {
        if (this.isDisposed) {
            throw new IllegalStateException("INavigatorContentExtension " + this.descriptor.getId() + " is disposed!");
        }
    }

    public IExtensionStateModel getStateModel() {
        return this.contentService.getExtensionStateService().getExtensionStateModel(this.getDescriptor());
    }

    public NavigatorContentExtension[] getOverridingExtensionsForTriggerPoint(Object anElement) {
        if (!this.descriptor.hasOverridingExtensions()) {
            return NO_EXTENSIONS;
        }
        LinkedHashSet<NavigatorContentExtension> overridingExtensions = new LinkedHashSet<NavigatorContentExtension>();
        Iterator contentDescriptorsItr = this.descriptor.getOverriddingExtensions().iterator();
        while (contentDescriptorsItr.hasNext()) {
            NavigatorContentDescriptor overriddingDescriptor = (NavigatorContentDescriptor)contentDescriptorsItr.next();
            if (!this.contentService.isActive(overriddingDescriptor.getId()) || !this.contentService.isVisible(overriddingDescriptor.getId()) || !overriddingDescriptor.isTriggerPoint(anElement)) continue;
            overridingExtensions.add(this.contentService.getExtension(overriddingDescriptor));
        }
        if (overridingExtensions.size() == 0) {
            return NO_EXTENSIONS;
        }
        return overridingExtensions.toArray(new NavigatorContentExtension[overridingExtensions.size()]);
    }

    public NavigatorContentExtension[] getOverridingExtensionsForPossibleChild(Object anElement) {
        if (!this.descriptor.hasOverridingExtensions()) {
            return NO_EXTENSIONS;
        }
        LinkedHashSet<NavigatorContentExtension> overridingExtensions = new LinkedHashSet<NavigatorContentExtension>();
        Iterator contentDescriptorsItr = this.descriptor.getOverriddingExtensions().iterator();
        while (contentDescriptorsItr.hasNext()) {
            NavigatorContentDescriptor overriddingDescriptor = (NavigatorContentDescriptor)contentDescriptorsItr.next();
            if (!this.contentService.isActive(overriddingDescriptor.getId()) || !this.contentService.isVisible(overriddingDescriptor.getId()) || !overriddingDescriptor.isPossibleChild(anElement)) continue;
            overridingExtensions.add(this.contentService.getExtension(overriddingDescriptor));
        }
        if (overridingExtensions.size() == 0) {
            return NO_EXTENSIONS;
        }
        return overridingExtensions.toArray(new NavigatorContentExtension[overridingExtensions.size()]);
    }

    public String toString() {
        return String.valueOf(this.descriptor.toString()) + " Instance";
    }
}

