/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class FileSystemExporter {
    private static final int DEFAULT_BUFFER_SIZE = 16384;

    public void createFolder(IPath destinationPath) {
        new File(destinationPath.toOSString()).mkdir();
    }

    public void write(IResource resource, IPath destinationPath) throws CoreException, IOException {
        if (resource.getType() == 1) {
            this.writeFile((IFile)resource, destinationPath);
        } else {
            this.writeChildren((IContainer)resource, destinationPath);
        }
    }

    protected void writeChildren(IContainer folder, IPath destinationPath) throws CoreException, IOException {
        if (folder.isAccessible()) {
            IResource[] children = folder.members();
            int i = 0;
            while (i < children.length) {
                IResource child = children[i];
                this.writeResource(child, destinationPath.append(child.getName()));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeFile(IFile file, IPath destinationPath) throws IOException, CoreException {
        block9: {
            output = null;
            contentStream = null;
            try {
                contentStream = new BufferedInputStream(file.getContents(false));
                output = new BufferedOutputStream(new FileOutputStream(destinationPath.toOSString()));
                available = contentStream.available();
                available = available <= 0 ? 16384 : available;
                chunkSize = Math.min(16384, available);
                readBuffer = new byte[chunkSize];
                n = contentStream.read(readBuffer);
                while (n > 0) {
                    output.write(readBuffer, 0, n);
                    n = contentStream.read(readBuffer);
                }
            }
            catch (Throwable var10_9) {
                var9_10 = null;
                if (contentStream != null) {
                    try {
                        contentStream.close();
                    }
                    catch (IOException e) {
                        IDEWorkbenchPlugin.log("Error closing input stream for file: " + file.getLocation(), e);
                    }
                }
                if (output == null) throw var10_9;
                output.close();
                throw var10_9;
            }
            {
                var9_11 = null;
                if (contentStream == null) break block9;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 133->141)] { 
lbl32:
            // 1 sources

            contentStream.close();
            break block9;
lbl34:
            // 1 sources

            catch (IOException e) {
                IDEWorkbenchPlugin.log("Error closing input stream for file: " + file.getLocation(), e);
            }
        }
        if (output == null) return;
        output.close();
    }

    protected void writeResource(IResource resource, IPath destinationPath) throws CoreException, IOException {
        if (resource.getType() == 1) {
            this.writeFile((IFile)resource, destinationPath);
        } else {
            this.createFolder(destinationPath);
            this.writeChildren((IContainer)resource, destinationPath);
        }
    }
}

