/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.expectation;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jmock.core.Verifiable;
import org.jmock.expectation.AssertMo;
import org.jmock.expectation.MockObject;
import org.jmock.expectation.Null;

public class ReturnObjectMap
extends MockObject {
    private final Hashtable returnValues = new Hashtable();
    private final String name;

    public ReturnObjectMap(String name) {
        this.name = name;
    }

    public Object getValue(Object key) {
        if (key == null) {
            key = Null.NULL;
        }
        AssertMo.assertTrue((String)(this.name + " does not contain " + key.toString()), (boolean)this.returnValues.containsKey(key));
        return ((CallCounter)this.returnValues.get(key)).getValue();
    }

    public Object getValue(short key) {
        return this.getValue(new Short(key));
    }

    public void putReturnValue(Object key, Object value) {
        this.returnValues.put(key != null ? key : Null.NULL, new CallCounter(key, value));
    }

    public void putReturnValue(Object key, int value) {
        this.putReturnValue(key, (Object)new Integer(value));
    }

    public void putReturnValue(short key, Object value) {
        this.putReturnValue((Object)new Short(key), value);
    }

    public void putReturnValue(Object key, boolean value) {
        this.putReturnValue(key, (Object)new Boolean(value));
    }

    public int getIntValue(Object key) {
        return (Integer)this.getValue(key);
    }

    public boolean getBooleanValue(String key) {
        return (Boolean)this.getValue(key);
    }

    public void verify() {
        super.verify();
        Enumeration enumeration = this.returnValues.elements();
        while (enumeration.hasMoreElements()) {
            ((Verifiable)enumeration.nextElement()).verify();
        }
    }

    private class CallCounter
    implements Verifiable {
        private int count = 0;
        private final Object value;
        private final Object key;

        public CallCounter(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getValue() {
            ++this.count;
            return this.value;
        }

        public void verify() {
            AssertMo.assertTrue((String)("Object never called for key: " + this.key), (this.count > 0 ? 1 : 0) != 0);
        }
    }
}

