/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.handlers.ShowViewHandler;
import org.eclipse.ui.internal.ShowViewAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ShowViewMenu
extends ContributionItem {
    private IWorkbenchWindow window;
    private static final String NO_TARGETS_MSG = WorkbenchMessages.Workbench_showInNoTargets;
    private Comparator actionComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (collator == null) {
                ShowViewMenu.collator = Collator.getInstance();
            }
            IAction a1 = (IAction)o1;
            IAction a2 = (IAction)o2;
            return collator.compare(a1.getText(), a2.getText());
        }
    };
    private Action showDlgAction;
    private Map actions = new HashMap(21);
    private Map openedViews = new HashMap();
    protected boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
            ShowViewMenu.this.dirty = true;
        }
    };
    private static Collator collator;
    private boolean makeFast;

    public ShowViewMenu(IWorkbenchWindow window, String id) {
        this(window, id, false);
    }

    public ShowViewMenu(IWorkbenchWindow window, String id, boolean makeFast) {
        super(id);
        this.window = window;
        this.showDlgAction = new Action(WorkbenchMessages.ShowView_title, makeFast){
            final ShowViewHandler handler;
            {
                this.handler = new ShowViewHandler(bl);
            }

            public void run() {
                try {
                    this.handler.execute(new ExecutionEvent());
                }
                catch (ExecutionException executionException) {}
            }
        };
        window.getWorkbench().getHelpSystem().setHelp((IAction)this.showDlgAction, "org.eclipse.ui.show_view_other_action_context");
        ((WorkbenchWindow)window).addSubmenu(1);
        this.showDlgAction.setActionDefinitionId("org.eclipse.ui.views.showView");
        this.makeFast = makeFast;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    private void fillMenu(IMenuManager innerMgr) {
        innerMgr.removeAll();
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            return;
        }
        if (page.getPerspective() == null) {
            return;
        }
        List viewIds = Arrays.asList(page.getShowViewShortcuts());
        viewIds = this.addOpenedViews(page, viewIds);
        ArrayList<IAction> actions = new ArrayList<IAction>(viewIds.size());
        Iterator i = viewIds.iterator();
        while (i.hasNext()) {
            IAction action;
            String id = (String)i.next();
            if (id.equals("org.eclipse.ui.internal.introview") || (action = this.getAction(id)) == null || WorkbenchActivityHelper.filterItem(action)) continue;
            actions.add(action);
        }
        Collections.sort(actions, this.actionComparator);
        i = actions.iterator();
        while (i.hasNext()) {
            innerMgr.add((IAction)i.next());
        }
        innerMgr.add((IContributionItem)new Separator());
        innerMgr.add((IAction)this.showDlgAction);
    }

    private List addOpenedViews(IWorkbenchPage page, List actions) {
        Object element;
        ArrayList views = this.getParts(page);
        ArrayList result = new ArrayList(views.size() + actions.size());
        int i = 0;
        while (i < actions.size()) {
            element = actions.get(i);
            if (result.indexOf(element) < 0) {
                result.add(element);
            }
            ++i;
        }
        i = 0;
        while (i < views.size()) {
            element = views.get(i);
            if (result.indexOf(element) < 0) {
                result.add(element);
            }
            ++i;
        }
        return result;
    }

    private IAction getAction(String id) {
        IViewRegistry reg;
        IViewDescriptor desc;
        Object action = (IAction)this.actions.get(id);
        if (action == null && (desc = (reg = WorkbenchPlugin.getDefault().getViewRegistry()).find(id)) != null) {
            action = new ShowViewAction(this.window, desc, this.makeFast);
            action.setActionDefinitionId(id);
            this.actions.put(id, action);
        }
        return action;
    }

    private ArrayList getParts(IWorkbenchPage page) {
        ArrayList parts = (ArrayList)this.openedViews.get(page);
        if (parts == null) {
            parts = new ArrayList();
            this.openedViews.put(page, parts);
        }
        return parts;
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        MenuManager manager = new MenuManager();
        this.fillMenu((IMenuManager)manager);
        IContributionItem[] items = manager.getItems();
        if (items.length == 0) {
            MenuItem item = new MenuItem(menu, 0, index++);
            item.setText(NO_TARGETS_MSG);
            item.setEnabled(false);
        } else {
            int i = 0;
            while (i < items.length) {
                items[i].fill(menu, index++);
                ++i;
            }
        }
        this.dirty = false;
    }

    protected void removeAction(String viewId) {
        this.actions.remove(viewId);
    }
}

