/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.internal.ISelectionConversionService;
import org.eclipse.ui.internal.LegacyResourceSupport;

public class SelectionConversionService
implements ISelectionConversionService {
    public IStructuredSelection convertToResources(IStructuredSelection originalSelection) {
        Class resourceClass = LegacyResourceSupport.getResourceClass();
        if (resourceClass == null) {
            return originalSelection;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator elements = originalSelection.iterator();
        while (elements.hasNext()) {
            Object adapter;
            Object currentElement = elements.next();
            if (resourceClass.isInstance(currentElement)) {
                result.add(currentElement);
                continue;
            }
            if (!(currentElement instanceof IAdaptable) || !resourceClass.isInstance(adapter = ((IAdaptable)currentElement).getAdapter(resourceClass))) continue;
            result.add(adapter);
        }
        if (result.isEmpty()) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection(result.toArray());
    }
}

