/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.quickdiff;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffMessages;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffReferenceProvider;

public class LastSaveReferenceProvider
implements IQuickDiffReferenceProvider,
IElementStateListener {
    private boolean fDocumentRead = false;
    private IDocument fReference = null;
    private String fId;
    private IDocumentProvider fDocumentProvider;
    private IEditorInput fEditorInput;
    private final Object fLock = new Object();
    private final Object fDocumentAccessorLock = new Object();
    private boolean fDocumentLocked;
    private IProgressMonitor fProgressMonitor;
    private ITextEditor fEditor;
    static /* synthetic */ Class class$0;

    public IDocument getReference(IProgressMonitor monitor) {
        if (!this.fDocumentRead) {
            this.readDocument(monitor, true);
        }
        return this.fReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        IProgressMonitor monitor = this.fProgressMonitor;
        if (monitor != null) {
            monitor.setCanceled(true);
        }
        IDocumentProvider provider = this.fDocumentProvider;
        Object object = this.fLock;
        synchronized (object) {
            if (provider != null) {
                provider.removeElementStateListener((IElementStateListener)this);
            }
            this.fEditorInput = null;
            this.fDocumentProvider = null;
            this.fReference = null;
            this.fDocumentRead = false;
            this.fProgressMonitor = null;
            this.fEditor = null;
        }
    }

    public String getId() {
        return this.fId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveEditor(ITextEditor targetEditor) {
        IDocumentProvider provider = null;
        IEditorInput input = null;
        if (targetEditor != null) {
            provider = targetEditor.getDocumentProvider();
            input = targetEditor.getEditorInput();
        }
        if (provider != this.fDocumentProvider || input != this.fEditorInput) {
            this.dispose();
            Object object = this.fLock;
            synchronized (object) {
                this.fEditor = targetEditor;
                this.fDocumentProvider = provider;
                this.fEditorInput = input;
            }
        }
    }

    public boolean isEnabled() {
        return this.fEditorInput != null && this.fDocumentProvider != null;
    }

    public void setId(String id) {
        this.fId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readDocument(IProgressMonitor monitor, boolean force) {
        IDocumentProvider prov = this.fDocumentProvider;
        IEditorInput inp = this.fEditorInput;
        IDocument doc = this.fReference;
        ITextEditor editor = this.fEditor;
        if (!(prov instanceof IStorageDocumentProvider)) return;
        if (!(inp instanceof IStorageEditorInput)) return;
        IStorageEditorInput input = (IStorageEditorInput)inp;
        IStorageDocumentProvider provider = (IStorageDocumentProvider)prov;
        if (doc == null) {
            if (!force) {
                if (!this.fDocumentRead) return;
            }
            doc = new Document();
        }
        IJobManager jobMgr = Platform.getJobManager();
        try {
            IStorage storage = input.getStorage();
            if (storage == null) {
                return;
            }
            this.fProgressMonitor = monitor;
            ISchedulingRule rule = this.getSchedulingRule(storage);
            try {
                this.lockDocument(monitor, jobMgr, rule);
                String encoding = storage instanceof IEncodedStorage ? ((IEncodedStorage)storage).getCharset() : null;
                boolean skipUTF8BOM = LastSaveReferenceProvider.isUTF8BOM(encoding, storage);
                LastSaveReferenceProvider.setDocumentContent(doc, storage, encoding, monitor, skipUTF8BOM);
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                this.unlockDocument(jobMgr, rule);
                this.fProgressMonitor = null;
                throw throwable;
            }
            {
                Object var14_16 = null;
                this.unlockDocument(jobMgr, rule);
                this.fProgressMonitor = null;
            }
        }
        catch (CoreException coreException) {
            return;
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        Object object = this.fLock;
        synchronized (object) {
            if (this.fDocumentProvider != provider) return;
            if (this.fEditorInput != input) return;
            this.fReference = doc;
            this.fDocumentRead = true;
            this.addElementStateListener(editor, prov);
            return;
        }
    }

    private ISchedulingRule getSchedulingRule(IStorage storage) {
        if (storage instanceof ISchedulingRule) {
            return (ISchedulingRule)storage;
        }
        if (storage != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.jobs.ISchedulingRule");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ISchedulingRule)storage.getAdapter((Class)clazz);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockDocument(IProgressMonitor monitor, IJobManager jobMgr, ISchedulingRule rule) {
        if (rule != null) {
            jobMgr.beginRule(rule, monitor);
        } else {
            Object object = this.fDocumentAccessorLock;
            synchronized (object) {
                while (this.fDocumentLocked) {
                    try {
                        this.fDocumentAccessorLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new OperationCanceledException();
                    }
                }
                this.fDocumentLocked = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockDocument(IJobManager jobMgr, ISchedulingRule rule) {
        if (rule != null) {
            jobMgr.endRule(rule);
        } else {
            Object object = this.fDocumentAccessorLock;
            synchronized (object) {
                this.fDocumentLocked = false;
                this.fDocumentAccessorLock.notifyAll();
            }
        }
    }

    private void addElementStateListener(ITextEditor editor, final IDocumentProvider provider) {
        Shell shell;
        IWorkbenchWindow window;
        IWorkbenchPartSite site;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = LastSaveReferenceProvider.this.fLock;
                synchronized (object) {
                    if (LastSaveReferenceProvider.this.fDocumentProvider == provider) {
                        provider.addElementStateListener((IElementStateListener)LastSaveReferenceProvider.this);
                    }
                }
            }
        };
        Display display = null;
        if (editor != null && (site = editor.getSite()) != null && (window = site.getWorkbenchWindow()) != null && (shell = window.getShell()) != null) {
            display = shell.getDisplay();
        }
        if (display != null && !display.isDisposed()) {
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void setDocumentContent(IDocument document, IStorage storage, String encoding, IProgressMonitor monitor, boolean skipUTF8BOM) throws CoreException {
        InputStream contentStream;
        Reader in;
        block18: {
            in = null;
            contentStream = storage.getContents();
            try {
                try {
                    if (skipUTF8BOM) {
                        int i = 0;
                        while (i < 3) {
                            if (contentStream.read() == -1) {
                                throw new IOException(QuickDiffMessages.getString("LastSaveReferenceProvider.LastSaveReferenceProvider.error.notEnoughBytesForBOM"));
                            }
                            ++i;
                        }
                    }
                    in = encoding == null ? new BufferedReader(new InputStreamReader(contentStream), 15360) : new BufferedReader(new InputStreamReader(contentStream, encoding), 15360);
                    StringBuffer buffer = new StringBuffer(15360);
                    char[] readBuffer = new char[2048];
                    int n = in.read(readBuffer);
                    while (true) {
                        if (n <= 0) {
                            document.set(buffer.toString());
                            break block18;
                        }
                        if (monitor != null && monitor.isCanceled()) {
                            Object var10_12 = null;
                            break;
                        }
                        buffer.append(readBuffer, 0, n);
                        n = in.read(readBuffer);
                    }
                }
                catch (IOException x) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, "Failed to access or read underlying storage", (Throwable)x));
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    if (in != null) {
                        in.close();
                        throw throwable;
                    }
                    contentStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (in != null) {
                in.close();
                return;
            }
            contentStream.close();
            return;
        }
        Object var10_14 = null;
        try {}
        catch (IOException iOException) {
            return;
        }
        if (in != null) {
            in.close();
            return;
        }
        contentStream.close();
    }

    private static boolean isUTF8BOM(String encoding, IStorage storage) throws CoreException {
        byte[] bom;
        IFile file;
        IContentDescription description;
        if (storage instanceof IFile && "UTF-8".equals(encoding) && (description = (file = (IFile)storage).getContentDescription()) != null && (bom = (byte[])description.getProperty(IContentDescription.BYTE_ORDER_MARK)) != null) {
            if (bom != IContentDescription.BOM_UTF_8) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, QuickDiffMessages.getString("LastSaveReferenceProvider.LastSaveReferenceProvider.error.wrongByteOrderMark"), null));
            }
            return true;
        }
        return false;
    }

    public void elementDirtyStateChanged(Object element, boolean isDirty) {
        if (!isDirty && element == this.fEditorInput) {
            new ReadJob().schedule();
        }
    }

    public void elementContentAboutToBeReplaced(Object element) {
    }

    public void elementContentReplaced(Object element) {
        if (element == this.fEditorInput) {
            new ReadJob().schedule();
        }
    }

    public void elementDeleted(Object element) {
    }

    public void elementMoved(Object originalElement, Object movedElement) {
    }

    private final class ReadJob
    extends Job {
        public ReadJob() {
            super(QuickDiffMessages.getString("LastSaveReferenceProvider.LastSaveReferenceProvider.readJob.label"));
            this.setSystem(true);
            this.setPriority(20);
        }

        protected IStatus run(IProgressMonitor monitor) {
            LastSaveReferenceProvider.this.readDocument(monitor, false);
            return Status.OK_STATUS;
        }
    }
}

