/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.internal.runners.BeforeAndAfterRunner;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.MethodValidator;
import org.junit.internal.runners.TestClassMethodsRunner;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestClassRunner
extends Runner
implements Filterable,
Sortable {
    protected final Runner fEnclosedRunner;
    private final Class<?> fTestClass;

    public TestClassRunner(Class<?> klass) throws InitializationError {
        this(klass, new TestClassMethodsRunner(klass));
    }

    public TestClassRunner(Class<?> klass, Runner runner) throws InitializationError {
        this.fTestClass = klass;
        this.fEnclosedRunner = runner;
        MethodValidator methodValidator = new MethodValidator(klass);
        this.validate(methodValidator);
        methodValidator.assertValid();
    }

    protected void validate(MethodValidator methodValidator) {
        methodValidator.validateMethodsForDefaultRunner();
    }

    @Override
    public void run(final RunNotifier notifier) {
        BeforeAndAfterRunner runner = new BeforeAndAfterRunner(this.getTestClass(), BeforeClass.class, AfterClass.class, null){

            protected void runUnprotected() {
                TestClassRunner.this.fEnclosedRunner.run(notifier);
            }

            protected void addFailure(Throwable targetException) {
                notifier.fireTestFailure(new Failure(TestClassRunner.this.getDescription(), targetException));
            }
        };
        runner.runProtected();
    }

    @Override
    public Description getDescription() {
        return this.fEnclosedRunner.getDescription();
    }

    @Override
    public void filter(Filter filter) throws NoTestsRemainException {
        filter.apply(this.fEnclosedRunner);
    }

    @Override
    public void sort(Sorter sorter) {
        sorter.apply(this.fEnclosedRunner);
    }

    protected Class<?> getTestClass() {
        return this.fTestClass;
    }
}

