/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.registry;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.runtime.OverlayIcon;
import org.eclipse.pde.internal.runtime.PDERuntimeMessages;
import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.registry.IBundleFolder;
import org.eclipse.pde.internal.runtime.registry.IBundleLibrary;
import org.eclipse.pde.internal.runtime.registry.IBundlePrerequisite;
import org.eclipse.pde.internal.runtime.registry.IConfigurationAttribute;
import org.eclipse.pde.internal.runtime.registry.PluginObjectAdapter;
import org.eclipse.pde.internal.runtime.registry.RegistryBrowserContentProvider;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class RegistryBrowserLabelProvider
extends LabelProvider {
    private Image fPluginImage;
    private Image fActivePluginImage;
    private Image fUnresolvedPluginImage;
    private Image fLibraryImage;
    private Image fRuntimeImage;
    private Image fGenericTagImage;
    private Image fGenericAttrImage;
    private Image fExtensionImage;
    private Image fExtensionsImage;
    private Image fExtensionPointImage;
    private Image fExtensionPointsImage;
    private Image fRequiresImage;
    private Image fExpReqPluginImage;
    private Image fReqPluginImage;
    private Image fLocationImage;
    private Image fDisabledImage;
    private Image fExporterImage;
    private Image fImporterImage;
    private Image fServiceImage;
    private TreeViewer fViewer;

    public RegistryBrowserLabelProvider(TreeViewer viewer) {
        this.fViewer = viewer;
        this.fPluginImage = PDERuntimePluginImages.DESC_PLUGIN_OBJ.createImage();
        this.fReqPluginImage = PDERuntimePluginImages.DESC_REQ_PLUGIN_OBJ.createImage();
        this.fExtensionPointImage = PDERuntimePluginImages.DESC_EXT_POINT_OBJ.createImage();
        this.fExtensionPointsImage = PDERuntimePluginImages.DESC_EXT_POINTS_OBJ.createImage();
        this.fExtensionImage = PDERuntimePluginImages.DESC_EXTENSION_OBJ.createImage();
        this.fExtensionsImage = PDERuntimePluginImages.DESC_EXTENSIONS_OBJ.createImage();
        this.fRequiresImage = PDERuntimePluginImages.DESC_REQ_PLUGINS_OBJ.createImage();
        this.fLibraryImage = PDERuntimePluginImages.DESC_JAVA_LIB_OBJ.createImage();
        this.fGenericTagImage = PDERuntimePluginImages.DESC_GENERIC_XML_OBJ.createImage();
        this.fGenericAttrImage = PDERuntimePluginImages.DESC_ATTR_XML_OBJ.createImage();
        this.fRuntimeImage = PDERuntimePluginImages.DESC_RUNTIME_OBJ.createImage();
        this.fLocationImage = PDERuntimePluginImages.DESC_LOCATION.createImage();
        this.fExporterImage = PDERuntimePluginImages.DESC_EXP_OBJ.createImage();
        this.fImporterImage = PDERuntimePluginImages.DESC_IMP_OBJ.createImage();
        this.fServiceImage = PDERuntimePluginImages.DESC_SERVICE_OBJ.createImage();
        OverlayIcon activePluginDesc = new OverlayIcon(PDERuntimePluginImages.DESC_PLUGIN_OBJ, new ImageDescriptor[][]{{PDERuntimePluginImages.DESC_RUN_CO}});
        this.fActivePluginImage = activePluginDesc.createImage();
        OverlayIcon disabledPluginDesc = new OverlayIcon(PDERuntimePluginImages.DESC_PLUGIN_OBJ, new ImageDescriptor[][]{{PDERuntimePluginImages.DESC_ERROR_CO}});
        this.fDisabledImage = disabledPluginDesc.createImage();
        OverlayIcon unresolvedPluginDesc = new OverlayIcon(PDERuntimePluginImages.DESC_PLUGIN_OBJ, new ImageDescriptor[][]{{PDERuntimePluginImages.DESC_ERROR_CO}});
        this.fUnresolvedPluginImage = unresolvedPluginDesc.createImage();
        OverlayIcon exportedRequiresDesc = new OverlayIcon(PDERuntimePluginImages.DESC_REQ_PLUGIN_OBJ, new ImageDescriptor[][]{{PDERuntimePluginImages.DESC_EXPORT_CO}});
        this.fExpReqPluginImage = exportedRequiresDesc.createImage();
    }

    public void dispose() {
        this.fPluginImage.dispose();
        this.fActivePluginImage.dispose();
        this.fUnresolvedPluginImage.dispose();
        this.fReqPluginImage.dispose();
        this.fExtensionPointImage.dispose();
        this.fExtensionPointsImage.dispose();
        this.fExtensionImage.dispose();
        this.fExtensionsImage.dispose();
        this.fRequiresImage.dispose();
        this.fExpReqPluginImage.dispose();
        this.fLibraryImage.dispose();
        this.fGenericTagImage.dispose();
        this.fGenericAttrImage.dispose();
        this.fRuntimeImage.dispose();
        this.fLocationImage.dispose();
        this.fDisabledImage.dispose();
        this.fImporterImage.dispose();
        this.fExporterImage.dispose();
        this.fServiceImage.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof PluginObjectAdapter) {
            element = ((PluginObjectAdapter)((Object)element)).getObject();
        }
        if (element instanceof Bundle) {
            BundleDescription description;
            Bundle bundle = (Bundle)element;
            PlatformAdmin plaformAdmin = PDERuntimePlugin.getDefault().getPlatformAdmin();
            State state = plaformAdmin.getState(false);
            if (state.getDisabledInfos(description = state.getBundle(bundle.getBundleId())).length > 0) {
                return this.fDisabledImage;
            }
            switch (bundle.getState()) {
                case 32: {
                    return this.fActivePluginImage;
                }
                case 1: {
                    return this.fUnresolvedPluginImage;
                }
                case 2: {
                    if (state.getDisabledInfos(description).length <= 0) break;
                    return this.fUnresolvedPluginImage;
                }
            }
            return this.fPluginImage;
        }
        if (element instanceof ServiceReference) {
            return this.fServiceImage;
        }
        if (element instanceof IBundleFolder) {
            int id = ((IBundleFolder)element).getFolderId();
            switch (id) {
                case 1: {
                    return this.fExtensionsImage;
                }
                case 2: {
                    return this.fExtensionPointsImage;
                }
                case 3: {
                    return this.fRequiresImage;
                }
                case 4: {
                    return this.fRuntimeImage;
                }
                case 0: {
                    return this.fLocationImage;
                }
                case 5: {
                    return this.fExporterImage;
                }
                case 6: {
                    return this.fImporterImage;
                }
            }
            return null;
        }
        if (element instanceof IExtension) {
            return this.fExtensionImage;
        }
        if (element instanceof IExtensionPoint) {
            return this.fExtensionPointImage;
        }
        if (element instanceof IBundlePrerequisite) {
            return ((IBundlePrerequisite)element).isExported() ? this.fExpReqPluginImage : this.fReqPluginImage;
        }
        if (element instanceof IBundleLibrary) {
            return this.fLibraryImage;
        }
        if (element instanceof IConfigurationElement) {
            return this.fGenericTagImage;
        }
        if (element instanceof IConfigurationAttribute) {
            return this.fGenericAttrImage;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof PluginObjectAdapter) {
            element = ((PluginObjectAdapter)((Object)element)).getObject();
        }
        if (element instanceof Bundle) {
            String id = ((Bundle)element).getSymbolicName();
            String version = (String)((Bundle)element).getHeaders().get("Bundle-Version");
            if (version == null) {
                return id;
            }
            return String.valueOf(id) + " (" + version + ")";
        }
        if (element instanceof ServiceReference) {
            ServiceReference ref = (ServiceReference)element;
            String[] classes = (String[])ref.getProperty("objectClass");
            Long id = (Long)ref.getProperty("service.id");
            String identifier = " (id=" + id.toString() + ")";
            return Arrays.asList(classes).toString().concat(identifier);
        }
        if (element instanceof IBundleFolder) {
            switch (((IBundleFolder)element).getFolderId()) {
                case 3: {
                    return PDERuntimeMessages.RegistryView_folders_imports;
                }
                case 4: {
                    return PDERuntimeMessages.RegistryView_folders_libraries;
                }
                case 2: {
                    return PDERuntimeMessages.RegistryView_folders_extensionPoints;
                }
                case 1: {
                    return PDERuntimeMessages.RegistryView_folders_extensions;
                }
                case 5: {
                    return PDERuntimeMessages.RegistryBrowserLabelProvider_registeredServices;
                }
                case 6: {
                    return PDERuntimeMessages.RegistryBrowserLabelProvider_usedServices;
                }
                case 0: {
                    Bundle bundle = ((IBundleFolder)element).getBundle();
                    URL bundleEntry = bundle.getEntry("/");
                    try {
                        bundleEntry = FileLocator.resolve((URL)bundleEntry);
                    }
                    catch (IOException iOException) {}
                    Path path = new Path(bundleEntry.getFile());
                    String pathString = path.removeTrailingSeparator().toOSString();
                    if (pathString.startsWith("file:")) {
                        pathString = pathString.substring(5);
                    }
                    if (pathString.endsWith("!")) {
                        pathString = pathString.substring(0, pathString.length() - 1);
                    }
                    return pathString;
                }
            }
        }
        if (element instanceof IExtension) {
            if (((RegistryBrowserContentProvider)this.fViewer.getContentProvider()).isInExtensionSet) {
                String name = ((IExtension)element).getLabel();
                String id = ((IExtension)element).getExtensionPointUniqueIdentifier();
                if (name != null && name.length() > 0) {
                    return NLS.bind((String)PDERuntimeMessages.RegistryBrowserLabelProvider_nameIdBind, (Object)id, (Object)name);
                }
                return id;
            }
            String contributor = ((IExtension)element).getNamespaceIdentifier();
            return NLS.bind((String)PDERuntimeMessages.RegistryBrowserLabelProvider_contributedBy, (Object)contributor);
        }
        if (element instanceof IExtensionPoint) {
            String id = ((IExtensionPoint)element).getUniqueIdentifier();
            String name = ((IExtensionPoint)element).getLabel();
            if (name != null && name.length() > 0) {
                return NLS.bind((String)PDERuntimeMessages.RegistryBrowserLabelProvider_nameIdBind, (Object)id, (Object)name);
            }
            return id;
        }
        if (element instanceof IBundlePrerequisite) {
            return ((IBundlePrerequisite)element).getLabel();
        }
        if (element instanceof IBundleLibrary) {
            return ((IBundleLibrary)element).getLibrary();
        }
        if (element instanceof IConfigurationElement) {
            String label = ((IConfigurationElement)element).getAttribute("label");
            if (label == null) {
                label = ((IConfigurationElement)element).getName();
            }
            if (label == null) {
                label = ((IConfigurationElement)element).getAttribute("name");
            }
            if (label == null && ((IConfigurationElement)element).getAttribute("id") != null) {
                String[] labelSplit = ((IConfigurationElement)element).getAttribute("id").split("\\.");
                label = labelSplit.length == 0 ? null : labelSplit[labelSplit.length - 1];
            }
            return label;
        }
        if (element instanceof IConfigurationAttribute) {
            return ((IConfigurationAttribute)element).getLabel();
        }
        return super.getText(element);
    }
}

