/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.registry;

import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.internal.runtime.registry.ExtensionAdapter;
import org.eclipse.pde.internal.runtime.registry.ExtensionPointAdapter;
import org.eclipse.pde.internal.runtime.registry.IBundleFolder;
import org.eclipse.pde.internal.runtime.registry.PluginAdapter;
import org.eclipse.pde.internal.runtime.registry.PluginObjectAdapter;
import org.eclipse.pde.internal.runtime.registry.RegistryBrowser;
import org.eclipse.pde.internal.runtime.registry.RegistryBrowserContentProvider;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class RegistryBrowserListener
implements IRegistryChangeListener,
BundleListener,
ServiceListener {
    protected RegistryBrowser fBrowser;
    protected boolean fExtOnly;

    protected RegistryBrowserListener(RegistryBrowser browser) {
        this.fBrowser = browser;
    }

    public void registryChanged(final IRegistryChangeEvent event) {
        Tree tree = this.fBrowser.getUndisposedTree();
        if (tree == null) {
            return;
        }
        tree.getDisplay().asyncExec(new Runnable(){

            public void run() {
                IExtensionDelta[] deltas = event.getExtensionDeltas();
                int i = 0;
                while (i < deltas.length) {
                    if (RegistryBrowserListener.this.fExtOnly) {
                        RegistryBrowserListener.this.handleExtOnlyEvent(deltas[i]);
                    } else {
                        RegistryBrowserListener.this.handleEvent(deltas[i]);
                    }
                    ++i;
                }
            }
        });
    }

    public void bundleChanged(final BundleEvent event) {
        Tree tree = this.fBrowser.getUndisposedTree();
        if (tree == null) {
            return;
        }
        tree.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (RegistryBrowserListener.this.fExtOnly) {
                    RegistryBrowserListener.this.handleExtOnlyEvent(event.getType(), event.getBundle());
                } else {
                    RegistryBrowserListener.this.handleEvent(event.getType(), event.getBundle());
                }
            }
        });
    }

    void handleEvent(IExtensionDelta delta) {
        this.handleDelta(delta, false);
    }

    void handleExtOnlyEvent(IExtensionDelta delta) {
        this.handleDelta(delta, true);
    }

    private void handleDelta(IExtensionDelta delta, boolean extOnly) {
        IExtension ext = delta.getExtension();
        IExtensionPoint extPoint = delta.getExtensionPoint();
        if (delta.getKind() == 1) {
            System.out.println("adding ");
            if (ext != null) {
                System.out.println("ext: " + ext.getUniqueIdentifier() + "/" + ext.getLabel() + " : " + ext.getExtensionPointUniqueIdentifier());
            }
            if (extPoint != null) {
                System.out.println("extPoint: " + extPoint.getUniqueIdentifier());
            }
            this.addExtensionObjectToTree(ext, extOnly);
            this.addExtensionObjectToTree(extPoint, extOnly);
        } else if (delta.getKind() == 2) {
            System.out.println("removing ");
            if (ext != null) {
                System.out.println("ext: " + ext.getUniqueIdentifier() + " : " + ext.getExtensionPointUniqueIdentifier());
            }
            if (extPoint != null) {
                System.out.println("extPoint: " + extPoint.getUniqueIdentifier());
            }
            this.removeFromTree(ext);
            this.removeFromTree(extPoint);
        }
    }

    private void addExtensionObjectToTree(Object child, boolean extOnly) {
        Object parent = null;
        if (!extOnly) {
            parent = this.getAdoptingBundleParent(child);
        } else {
            if (child instanceof IExtensionPoint) {
                this.fBrowser.add(child);
                return;
            }
            if (child instanceof IExtension) {
                String extPoint = ((IExtension)child).getExtensionPointUniqueIdentifier();
                TreeItem[] items = this.fBrowser.getTreeItems();
                int i = 0;
                while (i < items.length) {
                    Object data = items[i].getData();
                    if (data instanceof PluginObjectAdapter) {
                        data = ((PluginObjectAdapter)((Object)data)).getObject();
                    }
                    if (data instanceof IExtensionPoint && ((IExtensionPoint)data).getUniqueIdentifier().equals(extPoint)) {
                        parent = items[i].getData();
                        break;
                    }
                    ++i;
                }
            }
        }
        if (parent != null) {
            this.fBrowser.add(parent, child);
        }
    }

    private Object getAdoptingBundleParent(Object child) {
        TreeItem bundleItem = this.findBundleItem(this.getNamespaceIdentifier(child));
        if (bundleItem != null) {
            this.fBrowser.refresh(bundleItem.getData());
            this.fBrowser.updateItems(false);
            return null;
        }
        return null;
    }

    private TreeItem findBundleItem(String namespace) {
        if (namespace == null) {
            return null;
        }
        TreeItem[] items = this.fBrowser.getTreeItems();
        int i = 0;
        while (i < items.length) {
            Object data = items[i].getData();
            if (data instanceof PluginObjectAdapter) {
                data = ((PluginObjectAdapter)((Object)data)).getObject();
            }
            if (data instanceof Bundle && ((Bundle)data).getSymbolicName().equals(namespace)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    private String getNamespaceIdentifier(Object object) {
        if (object instanceof IExtensionPoint) {
            return ((IExtensionPoint)object).getNamespaceIdentifier();
        }
        if (object instanceof IExtension) {
            return ((IExtension)object).getContributor().getName();
        }
        return null;
    }

    private boolean correctFolder(IBundleFolder folder, Object child) {
        if (folder == null) {
            return false;
        }
        if (child instanceof IExtensionPoint) {
            return folder.getFolderId() == 2;
        }
        if (child instanceof IExtension) {
            return folder.getFolderId() == 1;
        }
        return false;
    }

    private void removeFromTree(Object object) {
        String namespace = this.getNamespaceIdentifier(object);
        if (namespace == null) {
            return;
        }
        TreeItem[] bundles = this.fBrowser.getTreeItems();
        int i = 0;
        while (i < bundles.length) {
            Object data = bundles[i].getData();
            Object adapted = null;
            if (data instanceof PluginObjectAdapter) {
                adapted = ((PluginObjectAdapter)((Object)data)).getObject();
            }
            if (adapted instanceof Bundle && ((Bundle)adapted).getSymbolicName().equals(namespace)) {
                bundles[i].getItems();
                this.fBrowser.refresh(data);
                this.fBrowser.updateItems(false);
                return;
            }
            ++i;
        }
    }

    protected Object findTreeBundleData(Object searchData) {
        Tree tree = this.fBrowser.getUndisposedTree();
        if (tree == null) {
            return null;
        }
        Object data = null;
        TreeItem[] items = this.fBrowser.getTreeItems();
        if (items == null) {
            return null;
        }
        int i = 0;
        while (i < items.length) {
            Object object;
            data = object = items[i].getData();
            if (object instanceof PluginObjectAdapter) {
                object = ((PluginObjectAdapter)((Object)object)).getObject();
            }
            if (searchData.equals(object)) {
                return data;
            }
            ++i;
        }
        return null;
    }

    void handleEvent(int changeType, Bundle bundle) {
        Object data = this.findTreeBundleData(bundle);
        switch (changeType) {
            case 1: {
                if (data != null) break;
                this.fBrowser.add((Object)new PluginAdapter(bundle));
                break;
            }
            case 16: {
                if (data == null) break;
                this.fBrowser.remove(data);
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: {
                if (data == null) break;
                this.fBrowser.update(data);
            }
        }
    }

    void handleExtOnlyEvent(int changeType, Bundle bundle) {
        switch (changeType) {
            case 1: 
            case 16: {
                IExtensionPoint[] points = Platform.getExtensionRegistry().getExtensionPoints(bundle.getSymbolicName());
                int i = 0;
                while (i < points.length) {
                    Object pointData = this.findTreeBundleData(points[i]);
                    if (pointData == null) {
                        if (changeType == 1) {
                            this.fBrowser.add((Object)new ExtensionPointAdapter(points[i]));
                        } else {
                            this.fBrowser.remove(pointData);
                        }
                    }
                    ++i;
                }
                IExtension[] extensions = Platform.getExtensionRegistry().getExtensions(bundle.getSymbolicName());
                int i2 = 0;
                while (i2 < extensions.length) {
                    String pointId = extensions[i2].getExtensionPointUniqueIdentifier();
                    if (changeType == 1) {
                        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(pointId);
                        Object pointData = this.findTreeBundleData(point);
                        if (pointData != null) {
                            this.fBrowser.add(pointData, (Object)new ExtensionAdapter(extensions[i2]));
                        }
                    } else {
                        Object extensionData = this.findTreeBundleData(extensions[i2]);
                        if (extensionData != null) {
                            this.fBrowser.remove(extensionData);
                        }
                    }
                    ++i2;
                }
                break;
            }
        }
    }

    public void serviceChanged(final ServiceEvent event) {
        Tree tree = this.fBrowser.getUndisposedTree();
        if (tree == null) {
            return;
        }
        tree.getDisplay().asyncExec(new Runnable(){

            public void run() {
                RegistryBrowserListener.this.handleServiceChangedEvent(event);
            }
        });
    }

    protected void handleServiceChangedEvent(ServiceEvent event) {
        ServiceReference ref = event.getServiceReference();
        switch (event.getType()) {
            case 1: 
            case 4: {
                Bundle bundle = ref.getBundle();
                if (bundle == null) {
                    return;
                }
                String name = bundle.getSymbolicName();
                if (name == null) {
                    return;
                }
                TreeItem bundleItem = this.findBundleItem(name);
                if (bundleItem == null) {
                    return;
                }
                PluginAdapter bundleAdapter = (PluginAdapter)((Object)bundleItem.getData());
                Object[] folders = bundleAdapter.getChildren();
                int j = 0;
                while (j < folders.length) {
                    IBundleFolder folder;
                    if (folders[j] instanceof IBundleFolder && (folder = (IBundleFolder)folders[j]).getFolderId() == 5 && (event.getType() == 1 || event.getType() == 4)) {
                        ((RegistryBrowserContentProvider.BundleFolder)folder).refresh();
                        this.fBrowser.refresh(folder);
                        this.fBrowser.refresh((Object)bundleAdapter);
                    }
                    ++j;
                }
                break;
            }
        }
    }
}

