/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import org.eclipse.equinox.internal.p2.ui.dialogs.AcceptLicensesWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.UpdateOrInstallWizardPage;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.LicenseManager;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public abstract class UpdateOrInstallWizard
extends Wizard {
    UpdateOrInstallWizardPage mainPage;
    AcceptLicensesWizardPage licensePage;
    protected String profileId;
    protected IInstallableUnit[] ius;
    protected LicenseManager licenseManager;

    public UpdateOrInstallWizard(String profileId, IInstallableUnit[] ius, LicenseManager licenseManager) {
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
        this.profileId = profileId;
        this.ius = ius;
        this.licenseManager = licenseManager;
    }

    public void addPages() {
        this.mainPage = this.createMainPage();
        this.addPage((IWizardPage)this.mainPage);
        this.licensePage = this.createLicensesPage();
        this.addPage((IWizardPage)this.licensePage);
    }

    protected abstract AcceptLicensesWizardPage createLicensesPage();

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.mainPage && this.licensePage.hasLicensesToAccept()) {
            return this.licensePage;
        }
        return null;
    }

    public boolean performFinish() {
        this.licensePage.performFinish();
        return this.mainPage.performFinish();
    }

    public void planChanged(IInstallableUnit[] selectedIUs, ProvisioningPlan plan) {
        this.ius = selectedIUs;
        this.licensePage.update(selectedIUs, plan);
    }

    protected abstract UpdateOrInstallWizardPage createMainPage();
}

