/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.operations;

import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.UndoableProvisioningOperation;

public abstract class ProfileOperation
extends UndoableProvisioningOperation {
    String[] profileIds;
    IProfile[] cachedProfiles;

    ProfileOperation(String label, String[] ids) {
        super(label);
        this.profileIds = ids;
    }

    ProfileOperation(String label, IProfile[] profiles) {
        super(label);
        Assert.isNotNull((Object)profiles);
        this.cachedProfiles = profiles;
        this.profileIds = new String[profiles.length];
        int i = 0;
        while (i < profiles.length) {
            this.profileIds[i] = profiles[i].getProfileId();
            ++i;
        }
    }

    boolean isValid() {
        return this.profileIds != null && this.profileIds.length > 0;
    }

    IProfile[] getProfiles() throws ProvisionException {
        if (this.profileIds == null) {
            return null;
        }
        if (this.cachedProfiles == null) {
            this.cachedProfiles = new IProfile[this.profileIds.length];
            int i = 0;
            while (i < this.profileIds.length) {
                this.cachedProfiles[i] = ProvisioningUtil.getProfile(this.profileIds[i]);
                ++i;
            }
        }
        return this.cachedProfiles;
    }
}

