/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.query;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.model.MetadataRepositories;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class QueryableMetadataRepositoryManager
implements IQueryable {
    private MetadataRepositories repositories;
    private ArrayList notFound = new ArrayList();
    private MultiStatus accumulatedNotFound = null;
    static /* synthetic */ Class class$0;

    public QueryableMetadataRepositoryManager(MetadataRepositories repositories) {
        this.repositories = repositories;
    }

    public Collector query(Query query, Collector result, IProgressMonitor monitor) {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            ProvUI.reportStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", ProvUIMessages.ProvisioningUtil_NoRepositoryManager), 3);
            return result;
        }
        List repoURLs = this.getRepoLocations(manager);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)ProvUIMessages.QueryableMetadataRepositoryManager_RepositoryQueryProgress, (int)(repoURLs.size() * 2));
        if (sub.isCanceled()) {
            return result;
        }
        int i = 0;
        while (i < repoURLs.size()) {
            if (sub.isCanceled()) {
                return result;
            }
            if (query == null) {
                result.accept(repoURLs.get(i));
                sub.worked(2);
            } else {
                URL url = (URL)repoURLs.get(i);
                try {
                    IMetadataRepository repo = manager.loadRepository(url, (IProgressMonitor)sub.newChild(1));
                    repo.query(query, result, (IProgressMonitor)sub.newChild(1));
                }
                catch (ProvisionException e) {
                    if (e.getStatus().getCode() == 1000) {
                        this.handleNotFound(e, url);
                    }
                    ProvUI.handleException(e, NLS.bind((String)ProvUIMessages.ProvisioningUtil_LoadRepositoryFailure, repoURLs.get(i)), 1);
                }
                this.reportAccumulatedStatus();
            }
            ++i;
        }
        return result;
    }

    public void loadAll(IProgressMonitor monitor) {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            ProvUI.reportStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", ProvUIMessages.ProvisioningUtil_NoRepositoryManager), 3);
            return;
        }
        List repoURLs = this.getRepoLocations(manager);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)ProvUIMessages.QueryableMetadataRepositoryManager_RepositoryQueryProgress, (int)(repoURLs.size() * 2));
        if (sub.isCanceled()) {
            return;
        }
        int i = 0;
        while (i < repoURLs.size()) {
            if (sub.isCanceled()) {
                return;
            }
            URL url = (URL)repoURLs.get(i);
            try {
                manager.loadRepository(url, (IProgressMonitor)sub.newChild(1));
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() == 1000) {
                    this.handleNotFound(e, url);
                }
                ProvUI.handleException(e, NLS.bind((String)ProvUIMessages.ProvisioningUtil_LoadRepositoryFailure, repoURLs.get(i)), 1);
            }
            ++i;
        }
        this.reportAccumulatedStatus();
    }

    private List getRepoLocations(IMetadataRepositoryManager manager) {
        ArrayList<URL> locations = new ArrayList<URL>();
        if (this.repositories.getMetadataRepositories() != null) {
            locations.addAll(Arrays.asList(this.repositories.getMetadataRepositories()));
        } else {
            locations.addAll(Arrays.asList(manager.getKnownRepositories(this.repositories.getRepoFlags())));
            if (this.repositories.getIncludeDisabledRepositories()) {
                locations.addAll(Arrays.asList(manager.getKnownRepositories(8)));
            }
        }
        return locations;
    }

    private void handleNotFound(ProvisionException e, URL missingRepo) {
        if (this.notFound.contains(missingRepo.toExternalForm())) {
            return;
        }
        if (ProvUI.hasNotFoundStatusBeenReported(missingRepo)) {
            this.notFound.add(missingRepo.toExternalForm());
            return;
        }
        this.notFound.add(missingRepo.toExternalForm());
        ProvUI.notFoundStatusReported(missingRepo);
        IStatus status = e.getStatus();
        if (status instanceof MultiStatus && ((MultiStatus)status).getChildren().length == 0) {
            status = new Status(4, status.getPlugin(), status.getCode(), status.getMessage(), status.getException());
        }
        if (this.accumulatedNotFound == null) {
            this.accumulatedNotFound = new MultiStatus("org.eclipse.equinox.p2.ui", 1000, new IStatus[]{status}, ProvUIMessages.QueryableMetadataRepositoryManager_MultipleRepositoriesNotFound, null);
        } else {
            this.accumulatedNotFound.add(status);
        }
    }

    private void reportAccumulatedStatus() {
        if (this.accumulatedNotFound != null) {
            if (this.accumulatedNotFound.getChildren().length == 1) {
                ProvUI.reportStatus(this.accumulatedNotFound.getChildren()[0], 2);
            } else {
                ProvUI.reportStatus((IStatus)this.accumulatedNotFound, 2);
            }
        }
        this.accumulatedNotFound = null;
    }

    public boolean areRepositoriesLoaded() {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null || !(manager instanceof MetadataRepositoryManager)) {
            return false;
        }
        MetadataRepositoryManager mgr = (MetadataRepositoryManager)manager;
        List repoURLs = this.getRepoLocations((IMetadataRepositoryManager)mgr);
        int i = 0;
        while (i < repoURLs.size()) {
            IMetadataRepository repo;
            if (repoURLs.get(i) instanceof URL && (repo = mgr.getRepository((URL)repoURLs.get(i))) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

