/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;

public final class Region
extends Resource {
    public int handle;

    public Region() {
        this(null);
    }

    public Region(Device device) {
        super(device);
        this.handle = OS.NewRgn();
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    Region(Device device, int handle) {
        super(device);
        this.handle = handle;
    }

    public void add(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if (pointArray.length < 2) {
            return;
        }
        int polyRgn = OS.NewRgn();
        OS.OpenRgn();
        OS.MoveTo((short)pointArray[0], (short)pointArray[1]);
        int i = 1;
        while (i < pointArray.length / 2) {
            OS.LineTo((short)pointArray[2 * i], (short)pointArray[2 * i + 1]);
            ++i;
        }
        OS.LineTo((short)pointArray[0], (short)pointArray[1]);
        OS.CloseRgn(polyRgn);
        OS.UnionRgn(this.handle, polyRgn, this.handle);
        OS.DisposeRgn(polyRgn);
    }

    public void add(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        if (rect.width < 0 || rect.height < 0) {
            SWT.error(5);
        }
        this.add(rect.x, rect.y, rect.width, rect.height);
    }

    public void add(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        int rectRgn = OS.NewRgn();
        Rect r = new Rect();
        OS.SetRect(r, (short)x, (short)y, (short)(x + width), (short)(y + height));
        OS.RectRgn(rectRgn, r);
        OS.UnionRgn(this.handle, rectRgn, this.handle);
        OS.DisposeRgn(rectRgn);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.UnionRgn(this.handle, region.handle, this.handle);
    }

    public boolean contains(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        org.eclipse.swt.internal.carbon.Point point = new org.eclipse.swt.internal.carbon.Point();
        OS.SetPt(point, (short)x, (short)y);
        return OS.PtInRgn(point, this.handle);
    }

    public boolean contains(Point pt) {
        if (pt == null) {
            SWT.error(4);
        }
        return this.contains(pt.x, pt.y);
    }

    void destroy() {
        OS.DisposeRgn(this.handle);
        this.handle = 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Rect bounds = new Rect();
        OS.GetRegionBounds(this.handle, bounds);
        int width = bounds.right - bounds.left;
        int height = bounds.bottom - bounds.top;
        return new Rectangle(bounds.left, bounds.top, width, height);
    }

    public static Region carbon_new(Device device, int handle) {
        return new Region(device, handle);
    }

    public int hashCode() {
        return this.handle;
    }

    public void intersect(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.intersect(rect.x, rect.y, rect.width, rect.height);
    }

    public void intersect(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        int rectRgn = OS.NewRgn();
        Rect r = new Rect();
        OS.SetRect(r, (short)x, (short)y, (short)(x + width), (short)(y + height));
        OS.RectRgn(rectRgn, r);
        OS.SectRgn(this.handle, rectRgn, this.handle);
        OS.DisposeRgn(rectRgn);
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.SectRgn(this.handle, region.handle, this.handle);
    }

    public boolean intersects(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Rect rect = new Rect();
        OS.SetRect(rect, (short)x, (short)y, (short)(x + width), (short)(y + height));
        return OS.RectInRgn(rect, this.handle);
    }

    public boolean intersects(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        return this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.EmptyRgn(this.handle);
    }

    public void subtract(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if (pointArray.length < 2) {
            return;
        }
        int polyRgn = OS.NewRgn();
        OS.OpenRgn();
        OS.MoveTo((short)pointArray[0], (short)pointArray[1]);
        int i = 1;
        while (i < pointArray.length / 2) {
            OS.LineTo((short)pointArray[2 * i], (short)pointArray[2 * i + 1]);
            ++i;
        }
        OS.LineTo((short)pointArray[0], (short)pointArray[1]);
        OS.CloseRgn(polyRgn);
        OS.DiffRgn(this.handle, polyRgn, this.handle);
        OS.DisposeRgn(polyRgn);
    }

    public void subtract(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.subtract(rect.x, rect.y, rect.width, rect.height);
    }

    public void subtract(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        int rectRgn = OS.NewRgn();
        Rect r = new Rect();
        OS.SetRect(r, (short)x, (short)y, (short)(x + width), (short)(y + height));
        OS.RectRgn(rectRgn, r);
        OS.DiffRgn(this.handle, rectRgn, this.handle);
        OS.DisposeRgn(rectRgn);
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.DiffRgn(this.handle, region.handle, this.handle);
    }

    public void translate(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.OffsetRgn(this.handle, (short)x, (short)y);
    }

    public void translate(Point pt) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pt == null) {
            SWT.error(4);
        }
        this.translate(pt.x, pt.y);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

