/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.debug.ui.memory.search;

import java.util.Properties;
import org.eclipse.dd.debug.ui.memory.search.FindReplaceDialog;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class FindAction
implements IViewActionDelegate {
    private MemoryView fView;
    private static Properties fSearchDialogProperties = new Properties();

    public void init(IViewPart view) {
        if (view instanceof MemoryView) {
            this.fView = (MemoryView)view;
        }
    }

    public void run(IAction action) {
        ISelection selection = this.fView.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strucSel = (IStructuredSelection)selection;
            if (strucSel.isEmpty()) {
                return;
            }
            Object obj = strucSel.getFirstElement();
            if (obj == null) {
                return;
            }
            IMemoryBlock memBlock = null;
            if (obj instanceof IMemoryRendering) {
                memBlock = ((IMemoryRendering)obj).getMemoryBlock();
            } else if (obj instanceof IMemoryBlock) {
                memBlock = (IMemoryBlock)obj;
            }
            Shell shell = DebugUIPlugin.getShell();
            FindReplaceDialog dialog = new FindReplaceDialog(shell, (IMemoryBlockExtension)memBlock, this.fView, fSearchDialogProperties);
            if (action.getText().equalsIgnoreCase("Find Next")) {
                if (fSearchDialogProperties.getProperty("SEARCH_ENABLE_FIND_NEXT", "false").equals("true")) {
                    dialog.performFindNext();
                }
                return;
            }
            dialog.open();
            Object[] results = dialog.getResult();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (action.getText().equalsIgnoreCase("Find Next")) {
            action.setEnabled(fSearchDialogProperties.getProperty("SEARCH_ENABLE_FIND_NEXT", "false").equals("true"));
        }
    }
}

