/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;

public class MacVMSearch {
    private static final String JAVA_VM_NAME = "Java HotSpot(TM) Client VM";
    private static final String JVM_VERSION_LOC = "/System/Library/Frameworks/JavaVM.framework/Versions/";
    private static final String CURRENT_JVM = "CurrentJDK";
    private static final String JVM_ROOT = "Home";

    public VMStandin[] search(IProgressMonitor monitor) {
        ArrayList<VMStandin> vms = new ArrayList<VMStandin>();
        IVMInstallType macVMType = this.getMacVMType();
        if (macVMType != null) {
            String javaVMName = System.getProperty("java.vm.name");
            if (javaVMName == null || !JAVA_VM_NAME.equals(javaVMName)) {
                return null;
            }
            File versionDir = new File(JVM_VERSION_LOC);
            if (versionDir.exists() && versionDir.isDirectory()) {
                File currentJDK = new File(versionDir, CURRENT_JVM);
                try {
                    currentJDK = currentJDK.getCanonicalFile();
                }
                catch (IOException iOException) {}
                File[] versions = versionDir.listFiles();
                monitor.beginTask(JREMessages.MacVMSearch_0, versions.length);
                int i = 0;
                while (i < versions.length) {
                    String version = versions[i].getName();
                    File home = new File(versions[i], JVM_ROOT);
                    if (home.exists()) {
                        boolean isDefault = currentJDK.equals(versions[i]);
                        if (!CURRENT_JVM.equals(version)) {
                            String arguments;
                            VMStandin vm = new VMStandin(macVMType, version);
                            vm.setInstallLocation(home);
                            String format = isDefault ? JREMessages.MacVMSearch_1 : JREMessages.MacVMSearch_2;
                            vm.setName(MessageFormat.format(format, version));
                            vm.setLibraryLocations(macVMType.getDefaultLibraryLocations(home));
                            URL doc = ((AbstractVMInstallType)macVMType).getDefaultJavadocLocation(home);
                            if (doc != null) {
                                vm.setJavadocLocation(doc);
                            }
                            if ((arguments = ((AbstractVMInstallType)macVMType).getDefaultVMArguments(home)) != null) {
                                vm.setVMArgs(arguments);
                            }
                            vms.add(vm);
                        }
                    }
                    monitor.worked(1);
                    ++i;
                }
            }
        }
        monitor.done();
        return vms.toArray(new VMStandin[vms.size()]);
    }

    private IVMInstallType getMacVMType() {
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstallType installType = types[i];
            if (installType.getId().equals("org.eclipse.jdt.internal.launching.macosx.MacOSXType")) {
                return installType;
            }
            ++i;
        }
        return null;
    }
}

