/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.pde.internal.ui.IPDEUIConstants;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.launcher.LaunchConfigurationListener;
import org.eclipse.pde.internal.ui.launcher.LaunchListener;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;
import org.eclipse.pde.internal.ui.launcher.OSGiFrameworkManager;
import org.eclipse.pde.internal.ui.launcher.PDELogFileProvider;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.internal.views.log.ILogFileProvider;
import org.eclipse.ui.internal.views.log.LogFilesManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class PDEPlugin
extends AbstractUIPlugin
implements IPDEUIConstants {
    private static PDEPlugin fInstance;
    private LaunchListener fLaunchListener;
    private BundleContext fBundleContext;
    private Hashtable fCounters;
    private ILogFileProvider fLogFileProvider;
    private FormColors fFormColors;
    private PDELabelProvider fLabelProvider;
    private DebugPluginUtil fDebugPluginUtil;
    private IDocumentProvider fTextFileDocumentProvider;
    private OSGiFrameworkManager fOSGiFrameworkManager;

    public PDEPlugin() {
        fInstance = this;
    }

    public URL getInstallURL() {
        return PDEPlugin.getDefault().getBundle().getEntry("/");
    }

    public static IWorkbenchPage getActivePage() {
        return PDEPlugin.getDefault().internalGetActivePage();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PDEPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PDEPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static PDEPlugin getDefault() {
        return fInstance;
    }

    public Hashtable getDefaultNameCounters() {
        if (this.fCounters == null) {
            this.fCounters = new Hashtable();
        }
        return this.fCounters;
    }

    public static String getPluginId() {
        return PDEPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private IWorkbenchPage internalGetActivePage() {
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        PDEPlugin.log((IStatus)new Status(4, PDEPlugin.getPluginId(), 4, message, null));
    }

    public static void logException(Throwable e, final String title, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, PDEPlugin.getPluginId(), 0, message, e);
        }
        ResourcesPlugin.getPlugin().getLog().log(status);
        Display display = SWTUtil.getStandardDisplay();
        final IStatus fstatus = status;
        display.asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError(null, (String)title, null, (IStatus)fstatus);
            }
        });
    }

    public static void logException(Throwable e) {
        PDEPlugin.logException(e, null, null);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, PDEPlugin.getPluginId(), 0, e.getMessage(), e);
        PDEPlugin.log(status);
    }

    public FormColors getFormColors(Display display) {
        if (this.fFormColors == null) {
            this.fFormColors = new FormColors(display);
            this.fFormColors.markShared();
        }
        return this.fFormColors;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fBundleContext = context;
        this.setupLaunchConfigurationListener();
        this.fLogFileProvider = new PDELogFileProvider();
        LogFilesManager.addLogFileProvider((ILogFileProvider)this.fLogFileProvider);
    }

    private void setupLaunchConfigurationListener() {
        boolean listenerStarted = false;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.debug.core");
        if (bundle != null && bundle.getState() == 32) {
            this.fDebugPluginUtil = new DebugPluginUtil();
            this.fDebugPluginUtil.addListener();
            listenerStarted = true;
        }
        if (!listenerStarted) {
            this.fBundleContext.addBundleListener(new BundleListener(){

                public void bundleChanged(BundleEvent event) {
                    if (event.getType() == 2 && "org.eclipse.debug.core".equals(event.getBundle().getSymbolicName())) {
                        PDEPlugin.this.fDebugPluginUtil = new DebugPluginUtil();
                        PDEPlugin.this.fDebugPluginUtil.addListener();
                        PDEPlugin.this.fBundleContext.removeBundleListener((BundleListener)this);
                    }
                }
            });
        }
    }

    public BundleContext getBundleContext() {
        return this.fBundleContext;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.fLaunchListener != null) {
            this.fLaunchListener.shutdown();
        }
        if (this.fFormColors != null) {
            this.fFormColors.dispose();
            this.fFormColors = null;
        }
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
            this.fLabelProvider = null;
        }
        if (this.fDebugPluginUtil != null) {
            this.fDebugPluginUtil.removeListener();
        }
        if (this.fLogFileProvider != null) {
            LogFilesManager.removeLogFileProvider((ILogFileProvider)this.fLogFileProvider);
            this.fLogFileProvider = null;
        }
        LauncherUtils.shutdown();
        super.stop(context);
    }

    public PDELabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new PDELabelProvider();
        }
        return this.fLabelProvider;
    }

    public LaunchListener getLaunchListener() {
        if (this.fLaunchListener == null) {
            this.fLaunchListener = new LaunchListener();
        }
        return this.fLaunchListener;
    }

    public OSGiFrameworkManager getOSGiFrameworkManager() {
        if (this.fOSGiFrameworkManager == null) {
            this.fOSGiFrameworkManager = new OSGiFrameworkManager();
        }
        return this.fOSGiFrameworkManager;
    }

    public static boolean isFullNameModeEnabled() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        return store.getString("Preferences.MainPage.showObjects").equals("useNames");
    }

    public synchronized IDocumentProvider getTextFileDocumentProvider() {
        if (this.fTextFileDocumentProvider == null) {
            this.fTextFileDocumentProvider = new TextFileDocumentProvider();
        }
        return this.fTextFileDocumentProvider;
    }

    private class DebugPluginUtil {
        private ILaunchConfigurationListener fLaunchConfigurationListener;

        private DebugPluginUtil() {
        }

        public void addListener() {
            if (this.fLaunchConfigurationListener == null) {
                this.fLaunchConfigurationListener = new LaunchConfigurationListener();
            }
            DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener(this.fLaunchConfigurationListener);
        }

        public void removeListener() {
            if (this.fLaunchConfigurationListener != null) {
                DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener(this.fLaunchConfigurationListener);
                this.fLaunchConfigurationListener = null;
            }
        }
    }
}

