/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.PDEDetails;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class PDEFormPage
extends FormPage {
    private boolean fNewStyleHeader = true;
    private Control fLastFocusControl = null;
    private boolean fStale = false;
    static /* synthetic */ Class class$0;

    public PDEFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public PDEFormPage(FormEditor editor, String id, String title, boolean newStyleHeader) {
        this(editor, id, title);
        this.fNewStyleHeader = newStyleHeader;
    }

    protected void markStale() {
        this.fStale = true;
    }

    protected boolean isStale() {
        return this.fStale;
    }

    protected void refresh() {
        this.fStale = false;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active && this.isStale()) {
            this.refresh();
        }
    }

    public void dispose() {
        Menu menu;
        Control c = this.getPartControl();
        if (c != null && !c.isDisposed() && (menu = c.getMenu()) != null) {
            this.resetMenu(menu, c);
        }
        super.dispose();
    }

    private void resetMenu(Menu menu, Control c) {
        Menu cmenu;
        if (c instanceof Composite) {
            Composite comp = (Composite)c;
            Control[] children = comp.getChildren();
            int i = 0;
            while (i < children.length) {
                this.resetMenu(menu, children[i]);
                ++i;
            }
        }
        if ((cmenu = c.getMenu()) != null && cmenu.equals(menu)) {
            c.setMenu(null);
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        final ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        if (this.fNewStyleHeader) {
            toolkit.decorateFormHeading(form.getForm());
        }
        IToolBarManager manager = form.getToolBarManager();
        this.getPDEEditor().contributeToToolbar(manager);
        final String href = this.getHelpResource();
        if (href != null) {
            Action helpAction = new Action("help"){

                public void run() {
                    BusyIndicator.showWhile((Display)form.getDisplay(), (Runnable)new Runnable(this, href){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ String val$href;
                        {
                            this.this$1 = var1_1;
                            this.val$href = string;
                        }

                        public void run() {
                            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(this.val$href);
                        }
                    });
                }
            };
            helpAction.setToolTipText(PDEUIMessages.PDEFormPage_help);
            helpAction.setImageDescriptor(PDEPluginImages.DESC_HELP);
            manager.add((IAction)helpAction);
        }
        IFormPart[] parts = managedForm.getParts();
        int i = 0;
        while (i < parts.length) {
            if (parts[i] instanceof IAdaptable) {
                IAction[] actions;
                IAdaptable adapter = (IAdaptable)parts[i];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("[Lorg.eclipse.jface.action.IAction;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((actions = (IAction[])adapter.getAdapter((Class)clazz)) != null) {
                    int j = 0;
                    while (j < actions.length) {
                        form.getToolBarManager().add(actions[j]);
                        ++j;
                    }
                }
            }
            ++i;
        }
        form.updateToolBar();
    }

    public PDEFormEditor getPDEEditor() {
        return (PDEFormEditor)this.getEditor();
    }

    protected String getHelpResource() {
        return null;
    }

    public IBaseModel getModel() {
        return this.getPDEEditor().getAggregateModel();
    }

    public void contextMenuAboutToShow(IMenuManager menu) {
    }

    protected Control getFocusControl() {
        IManagedForm form = this.getManagedForm();
        if (form == null) {
            return null;
        }
        ScrolledForm control = form.getForm();
        if (control == null || control.isDisposed()) {
            return null;
        }
        Display display = control.getDisplay();
        Control focusControl = display.getFocusControl();
        if (focusControl == null || focusControl.isDisposed()) {
            return null;
        }
        return focusControl;
    }

    public boolean performGlobalAction(String actionId) {
        Control focusControl = this.getFocusControl();
        if (focusControl == null) {
            return false;
        }
        if (this.canPerformDirectly(actionId, focusControl)) {
            return true;
        }
        AbstractFormPart focusPart = this.getFocusSection();
        if (focusPart != null) {
            if (focusPart instanceof PDESection) {
                return ((PDESection)focusPart).doGlobalAction(actionId);
            }
            if (focusPart instanceof PDEDetails) {
                return ((PDEDetails)focusPart).doGlobalAction(actionId);
            }
        }
        return false;
    }

    public boolean canPaste(Clipboard clipboard) {
        AbstractFormPart focusPart = this.getFocusSection();
        if (focusPart != null) {
            if (focusPart instanceof PDESection) {
                return ((PDESection)focusPart).canPaste(clipboard);
            }
            if (focusPart instanceof PDEDetails) {
                return ((PDEDetails)focusPart).canPaste(clipboard);
            }
        }
        return false;
    }

    public boolean canCopy(ISelection selection) {
        AbstractFormPart focusPart = this.getFocusSection();
        if (focusPart != null) {
            if (focusPart instanceof PDESection) {
                return ((PDESection)focusPart).canCopy(selection);
            }
            if (focusPart instanceof PDEDetails) {
                return ((PDEDetails)focusPart).canCopy(selection);
            }
        }
        return false;
    }

    public boolean canCut(ISelection selection) {
        AbstractFormPart focusPart = this.getFocusSection();
        if (focusPart != null) {
            if (focusPart instanceof PDESection) {
                return ((PDESection)focusPart).canCut(selection);
            }
            if (focusPart instanceof PDEDetails) {
                return ((PDEDetails)focusPart).canCut(selection);
            }
        }
        return false;
    }

    private AbstractFormPart getFocusSection() {
        Control focusControl = this.getFocusControl();
        if (focusControl == null) {
            return null;
        }
        Composite parent = focusControl.getParent();
        AbstractFormPart targetPart = null;
        while (parent != null) {
            Object data = parent.getData("part");
            if (data != null && data instanceof AbstractFormPart) {
                targetPart = (AbstractFormPart)data;
                break;
            }
            parent = parent.getParent();
        }
        return targetPart;
    }

    protected boolean canPerformDirectly(String id, Control control) {
        if (control instanceof Text) {
            Text text = (Text)control;
            if (id.equals(ActionFactory.CUT.getId())) {
                text.cut();
                return true;
            }
            if (id.equals(ActionFactory.COPY.getId())) {
                text.copy();
                return true;
            }
            if (id.equals(ActionFactory.PASTE.getId())) {
                text.paste();
                return true;
            }
            if (id.equals(ActionFactory.SELECT_ALL.getId())) {
                text.selectAll();
                return true;
            }
            if (id.equals(ActionFactory.DELETE.getId())) {
                int count = text.getSelectionCount();
                if (count == 0) {
                    int caretPos = text.getCaretPosition();
                    text.setSelection(caretPos, caretPos + 1);
                }
                text.insert("");
                return true;
            }
        }
        return false;
    }

    public void cancelEdit() {
        IFormPart[] parts = this.getManagedForm().getParts();
        int i = 0;
        while (i < parts.length) {
            IFormPart part = parts[i];
            if (part instanceof IContextPart) {
                ((IContextPart)part).cancelEdit();
            }
            ++i;
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IManagedForm managedForm = this.getManagedForm();
        if (managedForm != null) {
            this.addLastFocusListeners((Composite)managedForm.getForm());
        }
    }

    public void addLastFocusListeners(Composite composite) {
        Control[] controls = composite.getChildren();
        int i = 0;
        while (i < controls.length) {
            Control control = controls[i];
            if (control instanceof Text || control instanceof Button || control instanceof Combo || control instanceof CCombo || control instanceof Tree || control instanceof Table || control instanceof Spinner || control instanceof Link || control instanceof List || control instanceof TabFolder || control instanceof CTabFolder || control instanceof Hyperlink || control instanceof FilteredTree) {
                this.addLastFocusListener(control);
            }
            if (control instanceof Composite) {
                this.addLastFocusListeners((Composite)control);
            }
            ++i;
        }
    }

    private void addLastFocusListener(final Control control) {
        control.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                PDEFormPage.this.fLastFocusControl = control;
            }
        });
    }

    public void updateFormSelection() {
        if (this.fLastFocusControl != null && !this.fLastFocusControl.isDisposed()) {
            this.fLastFocusControl.setFocus();
            if (this.fLastFocusControl instanceof Text) {
                Text text = (Text)this.fLastFocusControl;
                text.setSelection(0, text.getText().length());
            }
        } else {
            this.setFocus();
        }
    }

    public Control getLastFocusControl() {
        return this.fLastFocusControl;
    }

    public void setLastFocusControl(Control control) {
        this.fLastFocusControl = control;
    }

    protected void createFormErrorContent(IManagedForm managedForm, String errorTitle, String errorMessage) {
        this.createFormErrorContent(managedForm, errorTitle, errorMessage, null);
    }

    protected void createFormErrorContent(IManagedForm managedForm, String errorTitle, String errorMessage, Exception e) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        if (this.fNewStyleHeader) {
            toolkit.decorateFormHeading(form.getForm());
        }
        Composite parent = form.getBody();
        GridLayout layout = new GridLayout();
        GridData data2 = new GridData(1808);
        layout.marginWidth = 7;
        layout.marginHeight = 7;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)data2);
        form.setText(errorTitle);
        form.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        int sectionStyle = 384;
        Section messageSection = this.createUISection(parent, PDEUIMessages.PDEFormPage_titleMessage, errorMessage, sectionStyle);
        Composite messageClient = this.createUISectionContainer((Composite)messageSection, 1);
        toolkit.paintBordersFor(messageClient);
        messageSection.setClient((Control)messageClient);
        if (e == null) {
            return;
        }
        Section detailsSection = this.createUISection(parent, PDEUIMessages.PDEFormPage_titleDetails, e.getMessage(), sectionStyle);
        Composite detailsClient = this.createUISectionContainer((Composite)detailsSection, 1);
        int style = 778;
        Text text = toolkit.createText(detailsClient, this.getStackTrace(e), style);
        GridData data = new GridData(768);
        data.heightHint = 160;
        data.widthHint = 200;
        text.setLayoutData((Object)data);
        toolkit.paintBordersFor(detailsClient);
        detailsSection.setClient((Control)detailsClient);
    }

    public Section createUISection(Composite parent, String text, String description, int style) {
        Section section = this.getManagedForm().getToolkit().createSection(parent, style);
        section.clientVerticalSpacing = 6;
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setText(text);
        section.setDescription(description);
        GridData data = new GridData(768);
        section.setLayoutData((Object)data);
        return section;
    }

    public Composite createUISectionContainer(Composite parent, int columns) {
        Composite container = this.getManagedForm().getToolkit().createComposite(parent);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, columns));
        return container;
    }

    public String getStackTrace(Throwable throwable) {
        StringWriter swriter = new StringWriter();
        PrintWriter pwriter = new PrintWriter(swriter);
        throwable.printStackTrace(pwriter);
        pwriter.flush();
        pwriter.close();
        return swriter.toString();
    }

    public void alignSectionHeaders(Section masterSection, Section detailsSection) {
        detailsSection.descriptionVerticalSpacing += masterSection.getTextClientHeightDifference();
    }
}

