/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.cheatsheet.comp;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.XMLRootElementMatcher;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class CompCSFileValidator
implements ISelectionStatusValidator {
    public IStatus validate(Object[] selection) {
        if (selection.length == 0) {
            return this.errorStatus("");
        }
        if (!(selection[0] instanceof IFile)) {
            return this.errorStatus("");
        }
        IFile file = (IFile)selection[0];
        if (!this.isSimpleCSFile(file)) {
            return this.errorStatus(PDEUIMessages.CompCSFileValidator_errorInvalidSimpleCS);
        }
        return this.okStatus("");
    }

    private boolean isSimpleCSFile(IFile file) {
        return XMLRootElementMatcher.fileMatchesElement(file, "cheatsheet");
    }

    private IStatus errorStatus(String message) {
        return new Status(4, PDEPlugin.getPluginId(), 4, message, null);
    }

    private IStatus okStatus(String message) {
        return new Status(0, PDEPlugin.getPluginId(), 0, message, null);
    }
}

