/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.cheatsheet.simple;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.cheatsheet.simple.SimpleCSObject;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ui.editor.PDEHyperlinkDetector;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.text.ResourceHyperlink;

public class SimpleCSHyperlinkDetector
extends PDEHyperlinkDetector {
    public SimpleCSHyperlinkDetector(PDESourcePage page) {
        super(page);
    }

    protected IHyperlink[] detectAttributeHyperlink(IDocumentAttributeNode attribute) {
        String attributeValue = attribute.getAttributeValue();
        if (!PDETextHelper.isDefinedAfterTrim((String)attributeValue)) {
            return null;
        }
        IDocumentElementNode node = attribute.getEnclosingElement();
        if (node == null) {
            return null;
        }
        if (!(node instanceof SimpleCSObject)) {
            return null;
        }
        SimpleCSObject csObject = (SimpleCSObject)node;
        ISimpleCSModel model = csObject.getModel();
        if (!model.isEditable()) {
            return null;
        }
        IResource resource = model.getUnderlyingResource();
        Region linkRegion = new Region(attribute.getValueOffset(), attribute.getValueLength());
        IHyperlink[] link = new IHyperlink[1];
        if (csObject.getType() == 6) {
            if (attribute.getAttributeName().equals("href")) {
                link[0] = new ResourceHyperlink((IRegion)linkRegion, attributeValue, resource);
            }
        } else if (csObject.getType() == 5 && attribute.getAttributeName().equals("href")) {
            link[0] = new ResourceHyperlink((IRegion)linkRegion, attributeValue, resource);
        }
        if (link[0] != null) {
            return link;
        }
        return null;
    }
}

