/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.feature.FeatureData;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureData;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.feature.OpenReferenceAction;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DataSection
extends TableSection {
    private TableViewer fDataViewer;
    private Action fNewAction;
    private Action fOpenAction;
    private Action fDeleteAction;

    public DataSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEUIMessages.FeatureEditor_DataSection_new});
        this.getSection().setText(PDEUIMessages.FeatureEditor_DataSection_title);
        this.getSection().setDescription(PDEUIMessages.FeatureEditor_DataSection_desc);
        this.getTablePart().setEditable(false);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.fDataViewer = tablePart.getTableViewer();
        this.fDataViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.fDataViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        toolkit.paintBordersFor(container);
        this.makeActions();
        section.setClient((Control)container);
        this.initialize();
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        this.fOpenAction.run();
    }

    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleNew();
        }
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public boolean setFormInput(Object object) {
        if (object instanceof IFeatureData) {
            this.fDataViewer.setSelection((ISelection)new StructuredSelection(object), true);
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fOpenAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fNewAction);
        manager.add((IAction)this.fDeleteAction);
        manager.add((IContributionItem)new Separator());
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void handleNew() {
        final IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IResource resource = model.getUnderlyingResource();
        final IContainer folder = resource.getParent();
        BusyIndicator.showWhile((Display)this.fDataViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ResourceSelectionDialog dialog = new ResourceSelectionDialog(DataSection.this.fDataViewer.getTable().getShell(), (IAdaptable)folder, null);
                dialog.open();
                Object[] result = dialog.getResult();
                DataSection.this.processNewResult(model, folder, result);
            }
        });
    }

    private void processNewResult(IFeatureModel model, IContainer folder, Object[] result) {
        if (result == null || result.length == 0) {
            return;
        }
        IPath folderPath = folder.getProjectRelativePath();
        ArrayList<String> entries = new ArrayList<String>();
        int i = 0;
        while (i < result.length) {
            int matching;
            IFile file;
            IPath filePath;
            IPath relativePath;
            String path;
            Object item = result[i];
            if (item instanceof IFile && this.canAdd(model, path = (relativePath = (filePath = (file = (IFile)item).getProjectRelativePath()).removeFirstSegments(matching = filePath.matchingFirstSegments(folderPath))).toString())) {
                entries.add(path);
            }
            ++i;
        }
        if (entries.size() > 0) {
            try {
                IFeatureData[] array = new IFeatureData[entries.size()];
                int i2 = 0;
                while (i2 < array.length) {
                    IFeatureData data = model.getFactory().createData();
                    String path = (String)entries.get(i2);
                    data.setId(path);
                    array[i2] = data;
                    ++i2;
                }
                model.getFeature().addData(array);
                this.fDataViewer.setSelection((ISelection)new StructuredSelection((Object)array[0]));
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private boolean canAdd(IFeatureModel model, String path) {
        if ("feature.xml".equals(path)) {
            return false;
        }
        IFeatureData[] data = model.getFeature().getData();
        int i = 0;
        while (i < data.length) {
            if (path.equals(data[i].getId())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void handleSelectAll() {
        IStructuredContentProvider provider = (IStructuredContentProvider)this.fDataViewer.getContentProvider();
        Object[] elements = provider.getElements(this.fDataViewer.getInput());
        StructuredSelection ssel = new StructuredSelection(elements);
        this.fDataViewer.setSelection((ISelection)ssel);
    }

    private void handleDelete() {
        IStructuredSelection ssel = (IStructuredSelection)this.fDataViewer.getSelection();
        if (ssel.isEmpty()) {
            return;
        }
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (!model.isEditable()) {
            return;
        }
        IFeature feature = model.getFeature();
        try {
            IFeatureData[] removed = new IFeatureData[ssel.size()];
            int i = 0;
            Iterator iter = ssel.iterator();
            while (iter.hasNext()) {
                IFeatureData iobj = (IFeatureData)iter.next();
                removed[i++] = iobj;
            }
            feature.removeData(removed);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            BusyIndicator.showWhile((Display)this.fDataViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    DataSection.this.handleDelete();
                }
            });
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            BusyIndicator.showWhile((Display)this.fDataViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    DataSection.this.handleSelectAll();
                }
            });
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        this.refresh();
        this.getTablePart().setButtonEnabled(0, model.isEditable());
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
            return;
        }
        Object obj = e.getChangedObjects()[0];
        if (obj instanceof IFeatureData && !(obj instanceof IFeaturePlugin)) {
            if (e.getChangeType() == 3) {
                this.fDataViewer.update(obj, null);
            } else if (e.getChangeType() == 1) {
                this.fDataViewer.add(e.getChangedObjects());
            } else if (e.getChangeType() == 2) {
                this.fDataViewer.remove(e.getChangedObjects());
            }
        }
    }

    private void makeActions() {
        IModel model = (IModel)this.getPage().getModel();
        this.fNewAction = new Action(){

            public void run() {
                DataSection.this.handleNew();
            }
        };
        this.fNewAction.setText(PDEUIMessages.Menus_new_label);
        this.fNewAction.setEnabled(model.isEditable());
        this.fDeleteAction = new Action(){

            public void run() {
                BusyIndicator.showWhile((Display)DataSection.this.fDataViewer.getTable().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        DataSection.access$2(5.access$0(this.this$1));
                    }
                });
            }

            static /* synthetic */ DataSection access$0(5 var0) {
                return var0.DataSection.this;
            }
        };
        this.fDeleteAction.setEnabled(model.isEditable());
        this.fDeleteAction.setText(PDEUIMessages.Actions_delete_label);
        this.fOpenAction = new OpenReferenceAction((ISelectionProvider)this.fDataViewer);
    }

    public void setFocus() {
        if (this.fDataViewer != null) {
            this.fDataViewer.getTable().setFocus();
        }
    }

    public void refresh() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        this.fDataViewer.setInput((Object)feature);
        super.refresh();
    }

    protected boolean canPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof FeaturePlugin || !(objects[i] instanceof FeatureData)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void doPaste() {
        ModelDataTransfer modelTransfer;
        Clipboard clipboard = this.getPage().getPDEEditor().getClipboard();
        Object[] objects = (Object[])clipboard.getContents((Transfer)(modelTransfer = ModelDataTransfer.getInstance()));
        if (objects != null) {
            this.doPaste(null, objects);
        }
    }

    protected void doPaste(Object target, Object[] objects) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        if (!model.isEditable()) {
            return;
        }
        FeatureData[] fData = new FeatureData[objects.length];
        try {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof FeatureData && !(objects[i] instanceof FeaturePlugin)) {
                    FeatureData fd = (FeatureData)objects[i];
                    fd.setModel(model);
                    fd.setParent((IFeatureObject)feature);
                    fData[i] = fd;
                }
                ++i;
            }
            feature.addData((IFeatureData[])fData);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    void fireSelection() {
        ISelection sel = this.fDataViewer.getSelection();
        if (!sel.isEmpty()) {
            this.fDataViewer.setSelection(this.fDataViewer.getSelection());
        } else if (this.fDataViewer.getElementAt(0) != null) {
            this.fDataViewer.setSelection((ISelection)new StructuredSelection(this.fDataViewer.getElementAt(0)));
        }
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        PluginContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IFeature) {
                return ((IFeature)parent).getData();
            }
            return new Object[0];
        }
    }
}

