/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.build.IBuildObject;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelProvider;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.IPDEUIConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.ILauncherFormPageHelper;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.JarEntryEditorInput;
import org.eclipse.pde.internal.ui.editor.JarEntryFile;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDELauncherFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.build.BuildInputContext;
import org.eclipse.pde.internal.ui.editor.build.BuildPage;
import org.eclipse.pde.internal.ui.editor.build.BuildSourcePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.BundleInputContext;
import org.eclipse.pde.internal.ui.editor.plugin.BundleSourcePage;
import org.eclipse.pde.internal.ui.editor.plugin.DependenciesPage;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionPointsPage;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionsPage;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestOutlinePage;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestSourcePage;
import org.eclipse.pde.internal.ui.editor.plugin.OverviewPage;
import org.eclipse.pde.internal.ui.editor.plugin.PluginExportAction;
import org.eclipse.pde.internal.ui.editor.plugin.PluginInputContext;
import org.eclipse.pde.internal.ui.editor.plugin.PluginInputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.PluginLauncherFormPageHelper;
import org.eclipse.pde.internal.ui.editor.plugin.PluginUndoManager;
import org.eclipse.pde.internal.ui.editor.plugin.RuntimePage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IShowEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.service.prefs.BackingStoreException;

public class ManifestEditor
extends PDELauncherFormEditor
implements IShowEditorInput {
    private static int BUILD_INDEX = 5;
    private static boolean SHOW_SOURCE;
    private boolean fEquinox = true;
    private boolean fShowExtensions = true;
    private IEclipsePreferences fPrefs;
    private PluginExportAction fExportAction;
    private ILauncherFormPageHelper fLauncherHelper;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected String getEditorID() {
        return "org.eclipse.pde.ui.manifestEditor";
    }

    public static IEditorPart openPluginEditor(String id) {
        return ManifestEditor.openPluginEditor(PluginRegistry.findModel((String)id));
    }

    public static IEditorPart openPluginEditor(IPluginModelBase model) {
        if (model == null) {
            Display.getDefault().beep();
            return null;
        }
        return ManifestEditor.openPluginEditor(model, false);
    }

    public static IEditorPart openPluginEditor(IPluginModelBase model, boolean source) {
        return ManifestEditor.open(model.getPluginBase(), source);
    }

    public static IEditorPart open(Object object, boolean source) {
        SHOW_SOURCE = source;
        if (object instanceof IPluginObject) {
            ISharedPluginModel model = ((IPluginObject)object).getModel();
            if (model instanceof IBundlePluginModelProvider) {
                model = ((IBundlePluginModelProvider)model).getBundlePluginModel();
            }
            if (model instanceof IPluginModelBase) {
                IResource resource;
                String filename;
                String string = filename = ((IPluginModelBase)model).isFragmentModel() ? "fragment.xml" : "plugin.xml";
                if (!(object instanceof IPluginExtension) && !(object instanceof IPluginExtensionPoint)) {
                    String installLocation = model.getInstallLocation();
                    if (installLocation == null) {
                        return null;
                    }
                    File file = new File(installLocation);
                    if (file.isFile()) {
                        if (CoreUtility.jarContainsResource((File)file, (String)"META-INF/MANIFEST.MF", (boolean)false)) {
                            filename = "META-INF/MANIFEST.MF";
                        }
                    } else if (new File(file, "META-INF/MANIFEST.MF").exists()) {
                        filename = "META-INF/MANIFEST.MF";
                    }
                }
                if ((resource = model.getUnderlyingResource()) == null) {
                    return ManifestEditor.openExternalPlugin(new File(model.getInstallLocation()), filename);
                }
                return ManifestEditor.openWorkspacePlugin(resource.getProject().getFile(filename));
            }
        }
        if (object instanceof BaseDescription) {
            BundleDescription desc = ((BaseDescription)object).getSupplier();
            String id = desc.getSymbolicName();
            String version = desc.getVersion().toString();
            ModelEntry entry = PluginRegistry.findEntry((String)id);
            IPluginModelBase[] models = entry.getActiveModels();
            int i = 0;
            while (i < models.length) {
                IPluginModelBase model = models[i];
                if (version.equals(model.getPluginBase().getVersion())) {
                    return ManifestEditor.open(model.getPluginBase(), true);
                }
                ++i;
            }
        }
        return null;
    }

    private static IEditorPart openWorkspacePlugin(IFile pluginFile) {
        return ManifestEditor.openEditor((IEditorInput)new FileEditorInput(pluginFile));
    }

    private static IEditorPart openExternalPlugin(File location, String filename) {
        Object input = null;
        if (location.isFile()) {
            try {
                ZipFile zipFile = new ZipFile(location);
                if (zipFile.getEntry(filename) != null) {
                    input = new JarEntryEditorInput(new JarEntryFile(zipFile, filename));
                }
            }
            catch (IOException iOException) {}
        } else {
            File file = new File(location, filename);
            if (file.exists()) {
                input = new SystemFileEditorInput(file);
            }
        }
        return ManifestEditor.openEditor(input);
    }

    public static IEditorPart openEditor(IEditorInput input) {
        if (input != null) {
            try {
                return PDEPlugin.getActivePage().openEditor(input, "org.eclipse.pde.ui.manifestEditor");
            }
            catch (PartInitException e) {
                PDEPlugin.logException(e);
            }
        }
        return null;
    }

    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        FileEditorInput in;
        IFile file = input.getFile();
        IContainer container = file.getParent();
        IFile manifestFile = null;
        IFile buildFile = null;
        IFile pluginFile = null;
        boolean fragment = false;
        String name = file.getName().toLowerCase(Locale.ENGLISH);
        if (name.equals("manifest.mf")) {
            if (container instanceof IFolder) {
                container = container.getParent();
            }
            manifestFile = file;
            buildFile = container.getFile(ICoreConstants.BUILD_PROPERTIES_PATH);
            pluginFile = this.createPluginFile(container);
        } else if (name.equals("plugin.xml") || name.equals("fragment.xml")) {
            pluginFile = file;
            fragment = name.equals("fragment.xml");
            buildFile = container.getFile(ICoreConstants.BUILD_PROPERTIES_PATH);
            manifestFile = container.getFile(ICoreConstants.MANIFEST_PATH);
        }
        if (manifestFile.exists()) {
            in = new FileEditorInput(manifestFile);
            manager.putContext((IEditorInput)in, new BundleInputContext(this, (IEditorInput)in, file == manifestFile));
        }
        if (pluginFile.exists()) {
            in = new FileEditorInput(pluginFile);
            manager.putContext((IEditorInput)in, new PluginInputContext(this, (IEditorInput)in, file == pluginFile, fragment));
        }
        if (buildFile.exists()) {
            in = new FileEditorInput(buildFile);
            manager.putContext((IEditorInput)in, new BuildInputContext(this, (IEditorInput)in, false));
        }
        manager.monitorFile(manifestFile);
        manager.monitorFile(pluginFile);
        manager.monitorFile(buildFile);
        this.fPrefs = new ProjectScope(container.getProject()).getNode("org.eclipse.pde.core");
        if (this.fPrefs != null) {
            this.fShowExtensions = this.fPrefs.getBoolean("pluginProject.extensions", true);
            this.fEquinox = this.fPrefs.getBoolean("pluginProject.equinox", true);
        }
    }

    protected InputContextManager createInputContextManager() {
        PluginInputContextManager manager = new PluginInputContextManager(this);
        manager.setUndoManager(new PluginUndoManager(this));
        return manager;
    }

    public void monitoredFileAdded(IFile file) {
        if (this.fInputContextManager == null) {
            return;
        }
        String name = file.getName();
        if (name.equalsIgnoreCase("MANIFEST.MF")) {
            if (!this.fInputContextManager.hasContext("bundle-context")) {
                FileEditorInput in = new FileEditorInput(file);
                this.fInputContextManager.putContext((IEditorInput)in, new BundleInputContext(this, (IEditorInput)in, false));
            }
        } else if (name.equalsIgnoreCase("plugin.xml")) {
            if (!this.fInputContextManager.hasContext("plugin-context")) {
                FileEditorInput in = new FileEditorInput(file);
                this.fInputContextManager.putContext((IEditorInput)in, new PluginInputContext(this, (IEditorInput)in, false, false));
            }
        } else if (name.equalsIgnoreCase("fragment.xml")) {
            if (!this.fInputContextManager.hasContext("plugin-context")) {
                FileEditorInput in = new FileEditorInput(file);
                this.fInputContextManager.putContext((IEditorInput)in, new PluginInputContext(this, (IEditorInput)in, false, true));
            }
        } else if (name.equalsIgnoreCase("build.properties") && !this.fInputContextManager.hasContext("build-context")) {
            FileEditorInput in = new FileEditorInput(file);
            this.fInputContextManager.putContext((IEditorInput)in, new BuildInputContext(this, (IEditorInput)in, false));
        }
    }

    public void ensurePluginContextPresence() {
        if (this.fInputContextManager.hasContext("plugin-context")) {
            return;
        }
        IProject project = this.fInputContextManager.getCommonProject();
        String name = this.fInputContextManager.getAggregateModel() instanceof IFragmentModel ? "fragment.xml" : "plugin.xml";
        IFile file = project.getFile(name);
        Object model = name.equals("fragment.xml") ? new WorkspaceFragmentModel(file, false) : new WorkspacePluginModel(file, false);
        IPluginBase pluginBase = model.getPluginBase(true);
        try {
            pluginBase.setSchemaVersion(TargetPlatformHelper.getTargetVersion() < 3.2 ? "3.0" : "3.2");
        }
        catch (CoreException coreException) {}
        model.save();
        FileEditorInput in = new FileEditorInput(file);
        this.fInputContextManager.putContext((IEditorInput)in, new PluginInputContext(this, (IEditorInput)in, false, false));
        this.updateBuildProperties(name);
    }

    private void updateBuildProperties(String filename) {
        try {
            InputContext context = this.fInputContextManager.findContext("build-context");
            if (context != null) {
                IBuildModel buildModel = (IBuildModel)context.getModel();
                IBuild build = buildModel.getBuild();
                IBuildEntry entry = build.getEntry("bin.includes");
                if (entry == null) {
                    entry = buildModel.getFactory().createEntry("bin.includes");
                    build.add(entry);
                }
                if (!entry.contains(filename)) {
                    entry.addToken(filename);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public boolean monitoredFileRemoved(IFile file) {
        return true;
    }

    public void editorContextAdded(InputContext context) {
        this.addSourcePage(context.getId());
        try {
            if (context.getId().equals("build-context")) {
                this.addPage(BUILD_INDEX, (IFormPage)new BuildPage(this));
            } else {
                this.updateFirstThreePages();
            }
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }

    public void contextRemoved(InputContext context) {
        this.close(true);
    }

    private void updateFirstThreePages() {
        try {
            int index = this.getActivePage();
            this.removePage(0);
            this.removePage(0);
            this.removePage(0);
            this.addPage(0, (IFormPage)new RuntimePage(this));
            this.addPage(0, (IFormPage)new DependenciesPage(this));
            this.addPage(0, (IFormPage)new OverviewPage(this));
            this.setActivePage(index);
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }

    protected void createSystemFileContexts(InputContextManager manager, SystemFileEditorInput input) {
        SystemFileEditorInput in;
        File dir;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.io.File");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        File file = (File)input.getAdapter(clazz);
        File manifestFile = null;
        File buildFile = null;
        File pluginFile = null;
        String name = file.getName().toLowerCase(Locale.ENGLISH);
        if (name.equals("manifest.mf")) {
            manifestFile = file;
            dir = file.getParentFile().getParentFile();
            buildFile = new File(dir, "build.properties");
            pluginFile = this.createPluginFile(dir);
        } else if (name.equals("build.properties")) {
            buildFile = file;
            dir = file.getParentFile();
            pluginFile = this.createPluginFile(dir);
            manifestFile = new File(dir, "META-INF/MANIFEST.MF");
        } else if (name.equals("plugin.xml") || name.equals("fragment.xml")) {
            pluginFile = file;
            dir = file.getParentFile();
            buildFile = new File(dir, "build.properties");
            manifestFile = new File(dir, "META-INF/MANIFEST.MF");
        }
        if (manifestFile.exists()) {
            in = new SystemFileEditorInput(manifestFile);
            manager.putContext((IEditorInput)in, new BundleInputContext(this, (IEditorInput)in, file == manifestFile));
        }
        if (pluginFile.exists()) {
            in = new SystemFileEditorInput(pluginFile);
            manager.putContext((IEditorInput)in, new PluginInputContext(this, (IEditorInput)in, file == pluginFile, name.equals("fragment.xml")));
        }
        if (buildFile.exists()) {
            in = new SystemFileEditorInput(buildFile);
            manager.putContext((IEditorInput)in, new BuildInputContext(this, (IEditorInput)in, file == buildFile));
        }
    }

    private File createPluginFile(File dir) {
        File pluginFile = new File(dir, "plugin.xml");
        if (!pluginFile.exists()) {
            pluginFile = new File(dir, "fragment.xml");
        }
        return pluginFile;
    }

    private IFile createPluginFile(IContainer container) {
        IFile pluginFile = container.getFile(ICoreConstants.PLUGIN_PATH);
        if (!pluginFile.exists()) {
            pluginFile = container.getFile(ICoreConstants.FRAGMENT_PATH);
        }
        return pluginFile;
    }

    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        if (input instanceof JarEntryEditorInput) {
            this.createJarEntryContexts(manager, (JarEntryEditorInput)input);
            return;
        }
        String name = input.getName().toLowerCase(Locale.ENGLISH);
        if (name.startsWith("manifest.mf")) {
            manager.putContext((IEditorInput)input, new BundleInputContext(this, (IEditorInput)input, true));
        } else if (name.startsWith("build.properties")) {
            manager.putContext((IEditorInput)input, new BuildInputContext(this, (IEditorInput)input, true));
        } else if (name.startsWith("plugin.xml")) {
            manager.putContext((IEditorInput)input, new PluginInputContext(this, (IEditorInput)input, true, false));
        } else if (name.startsWith("fragment.xml")) {
            manager.putContext((IEditorInput)input, new PluginInputContext(this, (IEditorInput)input, true, true));
        }
    }

    protected void createJarEntryContexts(InputContextManager manager, JarEntryEditorInput input) {
        ZipFile zip;
        IStorage storage;
        block21: {
            storage = input.getStorage();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.util.zip.ZipFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            zip = (ZipFile)storage.getAdapter((Class)clazz);
            try {
                if (zip != null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (zip != null) {
                        zip.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException iOException) {}
            return;
        }
        if (zip.getEntry("META-INF/MANIFEST.MF") != null) {
            input = new JarEntryEditorInput(new JarEntryFile(zip, "META-INF/MANIFEST.MF"));
            manager.putContext((IEditorInput)input, new BundleInputContext(this, (IEditorInput)input, storage.getName().equals("MANIFEST.MF")));
        }
        if (zip.getEntry("plugin.xml") != null) {
            input = new JarEntryEditorInput(new JarEntryFile(zip, "plugin.xml"));
            manager.putContext((IEditorInput)input, new PluginInputContext(this, (IEditorInput)input, storage.getName().equals("plugin.xml"), false));
        } else if (zip.getEntry("fragment.xml") != null) {
            input = new JarEntryEditorInput(new JarEntryFile(zip, "fragment.xml"));
            manager.putContext((IEditorInput)input, new PluginInputContext(this, (IEditorInput)input, storage.getName().equals("fragment.xml"), true));
        }
        if (zip.getEntry("build.properties") != null) {
            input = new JarEntryEditorInput(new JarEntryFile(zip, "build.properties"));
            manager.putContext((IEditorInput)input, new BuildInputContext(this, (IEditorInput)input, storage.getName().equals("build.properties")));
        }
        try {
            if (zip != null) {
                zip.close();
            }
        }
        catch (IOException iOException) {}
    }

    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new OverviewPage(this));
            this.addPage((IFormPage)new DependenciesPage(this));
            this.addPage((IFormPage)new RuntimePage(this));
            if (this.showExtensionTabs()) {
                this.addExtensionTabs();
            }
            if (this.fInputContextManager.hasContext("build-context")) {
                this.addPage((IFormPage)new BuildPage(this));
            }
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        this.addSourcePage("bundle-context");
        this.addSourcePage("plugin-context");
        this.addSourcePage("build-context");
    }

    private boolean isSourcePageID(String pageID) {
        if (pageID == null) {
            return false;
        }
        if (pageID.equals("build-context")) {
            return true;
        }
        if (pageID.equals("plugin-context")) {
            return true;
        }
        return pageID.equals("bundle-context");
    }

    protected String computeInitialPageId() {
        if (SHOW_SOURCE) {
            SHOW_SOURCE = false;
            return this.getPrimarySourceInputContextID();
        }
        String firstPageId = super.computeInitialPageId();
        if (firstPageId == null) {
            return "overview";
        }
        if (this.isSourcePageID(firstPageId)) {
            return this.getPrimarySourceInputContextID();
        }
        return firstPageId;
    }

    protected String getPropertyEditorPageKey(IFileEditorInput input) {
        IFile file = input.getFile();
        IProject project = file.getProject();
        if (project == null) {
            return super.getPropertyEditorPageKey(input);
        }
        try {
            return project.getPersistentProperty(IPDEUIConstants.PROPERTY_MANIFEST_EDITOR_PAGE_KEY);
        }
        catch (CoreException coreException) {
            return super.getPropertyEditorPageKey(input);
        }
    }

    protected void setPropertyEditorPageKey(IFileEditorInput input, String pageId) {
        IFile file = input.getFile();
        IProject project = file.getProject();
        if (project == null) {
            super.setPropertyEditorPageKey(input, pageId);
            return;
        }
        try {
            project.setPersistentProperty(IPDEUIConstants.PROPERTY_MANIFEST_EDITOR_PAGE_KEY, pageId);
        }
        catch (CoreException coreException) {
            super.setPropertyEditorPageKey(input, pageId);
            return;
        }
    }

    private String getPrimarySourceInputContextID() {
        InputContext primary = this.fInputContextManager.getPrimaryContext();
        if (primary == null) {
            return null;
        }
        return primary.getId();
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        if (contextId.equals("plugin-context")) {
            return new ManifestSourcePage(editor, title, name);
        }
        if (contextId.equals("build-context")) {
            return new BuildSourcePage(editor, title, name);
        }
        if (contextId.equals("bundle-context")) {
            return new BundleSourcePage(editor, title, name);
        }
        return super.createSourcePage(editor, title, name, contextId);
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new ManifestOutlinePage(this);
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return null;
        }
        return super.getAdapter(key);
    }

    public String getTitle() {
        IPluginModelBase model = (IPluginModelBase)this.getAggregateModel();
        if (model == null || !model.isValid()) {
            return super.getTitle();
        }
        String text = this.getTitleText(model.getPluginBase());
        if (text == null) {
            return super.getTitle();
        }
        return model.getResourceString(text);
    }

    public String getTitleProperty() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        String pref = store.getString("Preferences.MainPage.showObjects");
        if (pref != null && pref.equals("useNames")) {
            return "name";
        }
        return "id";
    }

    private String getTitleText(IPluginBase pluginBase) {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        String pref = store.getString("Preferences.MainPage.showObjects");
        if (pref != null && pref.equals("useNames")) {
            return pluginBase.getName();
        }
        return pluginBase.getId();
    }

    protected InputContext getInputContext(Object object) {
        InputContext context = null;
        if (object instanceof IFile) {
            String name = ((IFile)object).getName();
            if (name.equals("plugin.xml") || name.equals("fragment.xml")) {
                context = this.fInputContextManager.findContext("plugin-context");
            } else if (name.equals("MANIFEST.MF")) {
                context = this.fInputContextManager.findContext("bundle-context");
            } else if (name.equals("build.properties")) {
                context = this.fInputContextManager.findContext("build-context");
            }
        } else if (object instanceof IBuildObject) {
            context = this.fInputContextManager.findContext("build-context");
        } else if (object instanceof IPluginExtensionPoint || object instanceof IPluginExtension) {
            context = this.fInputContextManager.findContext("plugin-context");
        } else {
            context = this.fInputContextManager.findContext("bundle-context");
            if (context == null) {
                context = this.fInputContextManager.findContext("plugin-context");
            }
        }
        return context;
    }

    public void showEditorInput(IEditorInput editorInput) {
        String name = editorInput.getName();
        String id = this.getActivePageInstance().getId();
        if (name.equals("build.properties")) {
            if (!"build-context".equals(id)) {
                this.setActivePage(SHOW_SOURCE ? "build-context" : "build");
            }
        } else if (name.equals("plugin.xml") || name.equals("fragment.xml")) {
            if (!"plugin-context".equals(id)) {
                if (SHOW_SOURCE) {
                    this.setActivePage("plugin-context");
                } else if (this.fInputContextManager.hasContext("bundle-context")) {
                    this.setActivePage("extensions");
                } else {
                    this.setActivePage("overview");
                }
            }
        } else if (!"bundle-context".equals(id)) {
            this.setActivePage(SHOW_SOURCE ? "bundle-context" : "overview");
        }
    }

    public boolean showExtensionTabs() {
        if (this.fInputContextManager.hasContext("plugin-context")) {
            return true;
        }
        IBaseModel model = this.getAggregateModel();
        return this.fShowExtensions && model != null && model.isEditable();
    }

    public boolean isEquinox() {
        return this.fEquinox;
    }

    protected void addExtensionTabs() throws PartInitException {
        this.addPage(3, (IFormPage)new ExtensionPointsPage(this));
        this.addPage(3, (IFormPage)new ExtensionsPage(this));
    }

    protected void setShowExtensions(boolean show) throws BackingStoreException {
        if (this.fPrefs != null) {
            this.fPrefs.putBoolean("pluginProject.extensions", show);
            this.fPrefs.flush();
        }
        this.fShowExtensions = show;
    }

    public void contributeToToolbar(IToolBarManager manager) {
        this.contributeLaunchersToToolbar(manager);
        manager.add((IAction)this.getExportAction());
    }

    private PluginExportAction getExportAction() {
        if (this.fExportAction == null) {
            this.fExportAction = new PluginExportAction(this);
            this.fExportAction.setToolTipText(PDEUIMessages.PluginEditor_exportTooltip);
            this.fExportAction.setImageDescriptor(PDEPluginImages.DESC_EXPORT_PLUGIN_TOOL);
        }
        return this.fExportAction;
    }

    protected ILauncherFormPageHelper getLauncherHelper() {
        if (this.fLauncherHelper == null) {
            this.fLauncherHelper = new PluginLauncherFormPageHelper(this);
        }
        return this.fLauncherHelper;
    }
}

