/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.target;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.itarget.IImplicitDependenciesInfo;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.core.itarget.ITargetPlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ImplicitDependenciesSection
extends TableSection {
    private TableViewer fViewer;
    private static final int ADD_INDEX = 0;
    private static final int REMOVE_INDEX = 1;
    private static final int REMOVE_ALL_INDEX = 2;

    public ImplicitDependenciesSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEUIMessages.ImplicitDependenicesSection_Add, PDEUIMessages.ImplicitDependenicesSection_Remove, PDEUIMessages.ImplicitDependenicesSection_RemoveAll});
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setText(PDEUIMessages.ImplicitDependenicesSection_Title);
        section.setDescription(PDEUIMessages.TargetImplicitPluginsTab_desc);
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        container.setLayoutData((Object)new GridData(1808));
        this.createViewerPartControl(container, 2, 2, toolkit);
        this.fViewer = this.getTablePart().getTableViewer();
        this.fViewer.setContentProvider((IContentProvider)new DefaultTableProvider(){

            public Object[] getElements(Object inputElement) {
                return ImplicitDependenciesSection.this.getImplicitPluginsInfo().getPlugins();
            }
        });
        this.fViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ITargetPlugin p1 = (ITargetPlugin)e1;
                ITargetPlugin p2 = (ITargetPlugin)e2;
                return super.compare(viewer, (Object)p1.getId(), (Object)p2.getId());
            }
        });
        this.fViewer.setInput((Object)this.getTarget());
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImplicitDependenciesSection.this.updateButtons();
            }
        });
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        GridData gd = new GridData(1808);
        section.setLayoutData((Object)gd);
        this.updateButtons();
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    private void updateButtons() {
        EditableTablePart part = this.getTablePart();
        boolean empty = this.fViewer.getSelection().isEmpty();
        part.setButtonEnabled(1, !empty);
        boolean hasElements = this.fViewer.getTable().getItemCount() > 0;
        part.setButtonEnabled(2, hasElements);
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleRemove();
                break;
            }
            case 2: {
                this.handleRemoveAll();
            }
        }
    }

    protected void handleAdd() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)PDEPlugin.getDefault().getLabelProvider());
        dialog.setElements(this.getValidBundles());
        dialog.setTitle(PDEUIMessages.PluginSelectionDialog_title);
        dialog.setMessage(PDEUIMessages.PluginSelectionDialog_message);
        dialog.setMultipleSelection(true);
        if (dialog.open() == 0) {
            Object[] models = dialog.getResult();
            ArrayList<ITargetPlugin> pluginsToAdd = new ArrayList<ITargetPlugin>();
            ITargetModel model = this.getModel();
            int i = 0;
            while (i < models.length) {
                BundleDescription desc = (BundleDescription)models[i];
                ITargetPlugin plugin = model.getFactory().createPlugin();
                plugin.setId(desc.getSymbolicName());
                plugin.setModel(model);
                pluginsToAdd.add(plugin);
                ++i;
            }
            this.getImplicitPluginsInfo().addPlugins(pluginsToAdd.toArray(new ITargetPlugin[pluginsToAdd.size()]));
            this.updateButtons();
        }
    }

    protected Object[] getValidBundles() {
        ITargetPlugin[] plugins = this.getImplicitPluginsInfo().getPlugins();
        HashSet<String> currentPlugins = new HashSet<String>(1 * plugins.length + 1);
        int i = 0;
        while (i < plugins.length) {
            currentPlugins.add(plugins[i].getId());
            ++i;
        }
        IPluginModelBase[] models = PluginRegistry.getActiveModels((boolean)false);
        HashSet<BundleDescription> result = new HashSet<BundleDescription>(1 * models.length + 1);
        int i2 = 0;
        while (i2 < models.length) {
            BundleDescription desc = models[i2].getBundleDescription();
            if (desc != null && !currentPlugins.contains(desc.getSymbolicName())) {
                result.add(desc);
            }
            ++i2;
        }
        return result.toArray();
    }

    protected void handleRemove() {
        Object[] src = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        ITargetPlugin[] plugins = new ITargetPlugin[src.length];
        System.arraycopy(src, 0, plugins, 0, src.length);
        this.getImplicitPluginsInfo().removePlugins(plugins);
        this.updateButtons();
    }

    protected void handleRemoveAll() {
        IImplicitDependenciesInfo info = this.getImplicitPluginsInfo();
        info.removePlugins(info.getPlugins());
        this.updateButtons();
    }

    private IImplicitDependenciesInfo getImplicitPluginsInfo() {
        IImplicitDependenciesInfo info = this.getTarget().getImplicitPluginsInfo();
        if (info == null) {
            info = this.getModel().getFactory().createImplicitPluginInfo();
            this.getTarget().setImplicitPluginsInfo(info);
        }
        return info;
    }

    private ITarget getTarget() {
        return this.getModel().getTarget();
    }

    private ITargetModel getModel() {
        return (ITargetModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
            return;
        }
        if (e.getChangeType() == 3 && e.getChangedProperty().equals("implicit-plugins")) {
            ITargetPlugin[] plugins = (ITargetPlugin[])e.getOldValue();
            int i = 0;
            while (i < plugins.length) {
                this.fViewer.remove((Object)plugins[i]);
                ++i;
            }
            plugins = (ITargetPlugin[])e.getNewValue();
            i = 0;
            while (i < plugins.length) {
                this.fViewer.add((Object)plugins[i]);
                ++i;
            }
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.fViewer.setInput((Object)this.getTarget());
        this.refresh();
    }

    public void refresh() {
        this.fViewer.refresh();
        this.updateButtons();
        super.refresh();
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        this.handleOpen(selection);
    }

    private void handleOpen(IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        ManifestEditor.openPluginEditor(((ITargetPlugin)object).getId());
    }

    protected boolean canPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (!(objects[i] instanceof ITargetPlugin)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void doPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof ITargetPlugin) {
                this.getImplicitPluginsInfo().addPlugin((ITargetPlugin)objects[i]);
            }
            ++i;
        }
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
    }

    public void dispose() {
        ITargetModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
    }

    protected boolean createCount() {
        return true;
    }
}

