/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.target;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.itarget.IAdditionalLocation;
import org.eclipse.pde.internal.core.itarget.ILocationInfo;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.target.TargetEditor;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LocationDialog
extends StatusDialog {
    private Text fPath;
    private ITarget fTarget;
    private IAdditionalLocation fLocation;
    private IStatus fOkStatus;
    private IStatus fErrorStatus;

    public LocationDialog(Shell parent, ITarget target, IAdditionalLocation location) {
        super(parent);
        this.fTarget = target;
        this.fLocation = location;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.pde.doc.user.target_location_dialog");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.createEntry(container);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocationDialog.this.dialogChanged();
            }
        };
        this.fPath.addModifyListener(listener);
        this.setTitle(PDEUIMessages.LocationDialog_title);
        Dialog.applyDialogFont((Control)container);
        this.dialogChanged();
        return container;
    }

    protected void createEntry(Composite container) {
        Label label = new Label(container, 0);
        label.setText(PDEUIMessages.LocationDialog_path);
        label.setLayoutData((Object)new GridData());
        this.fPath = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.fPath.setLayoutData((Object)gd);
        if (this.fLocation != null) {
            this.fPath.setText(this.fLocation.getPath());
        }
        label = new Label(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Button fs = new Button(container, 8);
        fs.setText(PDEUIMessages.LocationDialog_fileSystem);
        fs.setLayoutData((Object)new GridData());
        fs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocationDialog.this.handleBrowseFileSystem();
            }
        });
        SWTUtil.setButtonDimensionHint(fs);
        Button var = new Button(container, 8);
        var.setText(PDEUIMessages.LocationDialog_variables);
        var.setLayoutData((Object)new GridData());
        var.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocationDialog.this.handleInsertVariable();
            }
        });
        SWTUtil.setButtonDimensionHint(var);
    }

    private IStatus createErrorStatus(String message) {
        return new Status(4, PDEPlugin.getPluginId(), 0, message, null);
    }

    private void dialogChanged() {
        IStatus status = null;
        if (this.fPath.getText().length() == 0) {
            status = this.getEmptyErrorStatus();
        } else if (this.hasPath(this.fPath.getText())) {
            status = this.createErrorStatus(PDEUIMessages.LocationDialog_locationExists);
        }
        if (status == null) {
            status = this.getOKStatus();
        }
        this.updateStatus(status);
    }

    private IStatus getOKStatus() {
        if (this.fOkStatus == null) {
            this.fOkStatus = new Status(0, PDEPlugin.getPluginId(), 0, "", null);
        }
        return this.fOkStatus;
    }

    private IStatus getEmptyErrorStatus() {
        if (this.fErrorStatus == null) {
            this.fErrorStatus = this.createErrorStatus(PDEUIMessages.LocationDialog_emptyPath);
        }
        return this.fErrorStatus;
    }

    protected boolean hasPath(String path) {
        Path currentPath;
        Path checkPath = new Path(path);
        Path path2 = currentPath = this.fLocation != null ? new Path(this.fLocation.getPath()) : null;
        if (checkPath.equals((Object)currentPath)) {
            return false;
        }
        IAdditionalLocation[] locs = this.fTarget.getAdditionalDirectories();
        int i = 0;
        while (i < locs.length) {
            if (new Path(locs[i].getPath()).equals((Object)checkPath)) {
                return true;
            }
            ++i;
        }
        return this.isTargetLocation(checkPath);
    }

    private boolean isTargetLocation(Path path) {
        ILocationInfo info = this.fTarget.getLocationInfo();
        if (info.useDefault()) {
            Path home = new Path(TargetPlatform.getDefaultLocation());
            return home.equals((Object)path);
        }
        return new Path(info.getPath()).equals((Object)path);
    }

    protected void handleBrowseFileSystem() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        String text = this.fPath.getText();
        if (text.length() == 0) {
            text = TargetEditor.LAST_PATH;
        }
        dialog.setFilterPath(text);
        dialog.setText(PDEUIMessages.BaseBlock_dirSelection);
        dialog.setMessage(PDEUIMessages.BaseBlock_dirChoose);
        String result = dialog.open();
        if (result != null) {
            this.fPath.setText(result);
            TargetEditor.LAST_PATH = result;
        }
    }

    private void handleInsertVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            this.fPath.insert(dialog.getVariableExpression());
        }
    }

    protected void okPressed() {
        boolean add;
        boolean bl = add = this.fLocation == null;
        if (add) {
            this.fLocation = this.fTarget.getModel().getFactory().createAdditionalLocation();
        }
        this.fLocation.setPath(this.fPath.getText());
        if (add) {
            this.fTarget.addAdditionalDirectories(new IAdditionalLocation[]{this.fLocation});
        }
        super.okPressed();
    }
}

