/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.target;

import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.itarget.IAdditionalLocation;
import org.eclipse.pde.internal.core.itarget.ILocationInfo;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.target.LocationDialog;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class LocationsSection
extends TableSection {
    private TableViewer fContentViewer;

    public LocationsSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEUIMessages.LocationsSection_add, PDEUIMessages.LocationsSection_edit, PDEUIMessages.LocationsSection_remove});
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        client.setLayoutData((Object)new GridData(1808));
        this.createViewerPartControl(client, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        GridData data = (GridData)tablePart.getControl().getLayoutData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        this.fContentViewer = tablePart.getTableViewer();
        this.fContentViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fContentViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fContentViewer.setInput((Object)this.getTarget());
        this.fContentViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LocationsSection.this.updateButtons();
            }
        });
        this.fContentViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IAdditionalLocation loc1 = (IAdditionalLocation)e1;
                return loc1.getPath().compareToIgnoreCase(((IAdditionalLocation)e2).getPath());
            }
        });
        this.fContentViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (((StructuredSelection)LocationsSection.this.fContentViewer.getSelection()).toArray().length == 1) {
                    LocationsSection.this.handleEdit();
                }
            }
        });
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        section.setText(PDEUIMessages.LocationsSection_title);
        section.setDescription(PDEUIMessages.LocationsSection_description);
        GridData sectionData = new GridData(1808);
        sectionData.horizontalSpan = 2;
        section.setLayoutData((Object)sectionData);
        this.updateButtons();
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    private ITarget getTarget() {
        return this.getModel().getTarget();
    }

    private ITargetModel getModel() {
        return (ITargetModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    protected void updateButtons() {
        int selectionNum = ((StructuredSelection)this.fContentViewer.getSelection()).toArray().length;
        EditableTablePart table = this.getTablePart();
        table.setButtonEnabled(1, selectionNum == 1);
        table.setButtonEnabled(2, selectionNum > 0);
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleEdit();
                break;
            }
            case 2: {
                this.handleDelete();
            }
        }
    }

    protected void handleAdd() {
        this.showDialog(null);
    }

    protected void handleEdit() {
        this.showDialog((IAdditionalLocation)((StructuredSelection)this.fContentViewer.getSelection()).iterator().next());
    }

    protected void handleDelete() {
        IStructuredSelection ssel = (IStructuredSelection)this.fContentViewer.getSelection();
        if (ssel.size() > 0) {
            Object[] objects = ssel.toArray();
            ITarget target = this.getTarget();
            IAdditionalLocation[] dirs = new IAdditionalLocation[objects.length];
            System.arraycopy(objects, 0, dirs, 0, objects.length);
            target.removeAdditionalDirectories(dirs);
        }
    }

    private void showDialog(final IAdditionalLocation location) {
        final ITarget model = this.getTarget();
        BusyIndicator.showWhile((Display)this.fContentViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                LocationDialog dialog = new LocationDialog(LocationsSection.this.fContentViewer.getTable().getShell(), model, location);
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, 500, -1);
                dialog.open();
            }
        });
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
            return;
        }
        Object[] objects = e.getChangedObjects();
        if (e.getChangeType() == 1) {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof IAdditionalLocation) {
                    this.fContentViewer.add(objects[i]);
                }
                ++i;
            }
        } else if (e.getChangeType() == 2) {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof IAdditionalLocation) {
                    this.fContentViewer.remove(objects[i]);
                }
                ++i;
            }
        }
        if (e.getChangedProperty() == "path") {
            this.fContentViewer.refresh();
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.fContentViewer.setInput((Object)this.getTarget());
        this.refresh();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    protected boolean canPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof IAdditionalLocation) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void doPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof IAdditionalLocation && !this.hasPath(((IAdditionalLocation)objects[i]).getPath())) {
                IAdditionalLocation loc = (IAdditionalLocation)objects[i];
                loc.setModel(this.getModel());
                this.getTarget().addAdditionalDirectories(new IAdditionalLocation[]{loc});
            }
            ++i;
        }
    }

    protected boolean hasPath(String path) {
        Path checkPath = new Path(path);
        IAdditionalLocation[] locs = this.getModel().getTarget().getAdditionalDirectories();
        int i = 0;
        while (i < locs.length) {
            if (new Path(locs[i].getPath()).equals((Object)checkPath)) {
                return true;
            }
            ++i;
        }
        return this.isTargetLocation(checkPath);
    }

    private boolean isTargetLocation(Path path) {
        ILocationInfo info = this.getModel().getTarget().getLocationInfo();
        if (info.useDefault()) {
            Path home = new Path(TargetPlatform.getDefaultLocation());
            return home.equals((Object)path);
        }
        return new Path(info.getPath()).equals((Object)path);
    }

    public void dispose() {
        ITargetModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void refresh() {
        this.fContentViewer.refresh();
        this.updateButtons();
        super.refresh();
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection ssel = (IStructuredSelection)this.fContentViewer.getSelection();
        if (ssel == null) {
            return;
        }
        Action removeAction = new Action(PDEUIMessages.ContentSection_remove){

            public void run() {
                LocationsSection.this.handleDelete();
            }
        };
        removeAction.setEnabled(this.isEditable() && ssel.size() > 0);
        manager.add((IAction)removeAction);
        manager.add((IContributionItem)new Separator());
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
    }

    class ContentProvider
    extends DefaultTableProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object parent) {
            ITarget target = LocationsSection.this.getTarget();
            return target.getAdditionalDirectories();
        }
    }
}

