/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.target;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.pde.internal.core.LoadTargetOperation;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.target.ContentPage;
import org.eclipse.pde.internal.ui.editor.target.EnvironmentPage;
import org.eclipse.pde.internal.ui.editor.target.OverviewPage;
import org.eclipse.pde.internal.ui.editor.target.TargetErrorDialog;
import org.eclipse.pde.internal.ui.editor.target.TargetInputContext;
import org.eclipse.pde.internal.ui.editor.target.TargetInputContextManager;
import org.eclipse.pde.internal.ui.editor.target.TargetOutlinePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.progress.IProgressService;

public class TargetEditor
extends PDEFormEditor {
    protected static String LAST_PATH;
    static /* synthetic */ Class class$0;

    static {
        Location installLoc = Platform.getInstallLocation();
        if (installLoc == null) {
            LAST_PATH = "";
        }
        URL url = installLoc.getURL();
        LAST_PATH = new Path(url.getPath()).toOSString();
    }

    protected String getEditorID() {
        return "org.eclipse.pde.ui.targetEditor";
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public String getContextIDForSaveAs() {
        return "target-context";
    }

    protected InputContextManager createInputContextManager() {
        return new TargetInputContextManager(this);
    }

    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        manager.putContext((IEditorInput)input, new TargetInputContext(this, (IEditorInput)input, true));
        manager.monitorFile(input.getFile());
    }

    protected void createSystemFileContexts(InputContextManager manager, SystemFileEditorInput input) {
        String name;
        File file;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.io.File");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((file = (File)input.getAdapter(clazz)) != null && (name = file.getName()).endsWith(".target")) {
            SystemFileEditorInput in = new SystemFileEditorInput(file);
            manager.putContext((IEditorInput)in, new TargetInputContext(this, (IEditorInput)in, true));
        }
    }

    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        if (input.getName().endsWith(".target")) {
            manager.putContext((IEditorInput)input, new TargetInputContext(this, (IEditorInput)input, true));
        }
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new TargetOutlinePage(this);
    }

    protected InputContext getInputContext(Object object) {
        return this.fInputContextManager.findContext("target-context");
    }

    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new OverviewPage(this));
            this.addPage((IFormPage)new ContentPage(this));
            this.addPage((IFormPage)new EnvironmentPage(this));
            this.addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    Object o = event.getSelectedPage();
                    if (o instanceof EnvironmentPage) {
                        ((EnvironmentPage)((Object)o)).updateChoices();
                    }
                }
            });
        }
        catch (PartInitException e) {
            PDEPlugin.log(e);
        }
    }

    public void editorContextAdded(InputContext context) {
    }

    public void contextRemoved(InputContext context) {
        this.close(false);
    }

    public void monitoredFileAdded(IFile monitoredFile) {
    }

    public boolean monitoredFileRemoved(IFile monitoredFile) {
        return true;
    }

    public void contributeToToolbar(IToolBarManager manager) {
        ControlContribution save = new ControlContribution("Set"){

            protected Control createControl(Composite parent) {
                ImageHyperlink hyperlink = new ImageHyperlink(parent, 0);
                hyperlink.setText(PDEUIMessages.AbstractTargetPage_setTarget);
                hyperlink.setUnderlined(true);
                hyperlink.setForeground(TargetEditor.this.getToolkit().getHyperlinkGroup().getForeground());
                hyperlink.addHyperlinkListener(new IHyperlinkListener(this, hyperlink){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ ImageHyperlink val$hyperlink;
                    {
                        this.this$1 = var1_1;
                        this.val$hyperlink = imageHyperlink;
                    }

                    public void linkActivated(HyperlinkEvent e) {
                        TargetEditor.access$0(2.access$0(this.this$1));
                    }

                    public void linkEntered(HyperlinkEvent e) {
                        this.val$hyperlink.setForeground(2.access$0(this.this$1).getToolkit().getHyperlinkGroup().getActiveForeground());
                    }

                    public void linkExited(HyperlinkEvent e) {
                        this.val$hyperlink.setForeground(2.access$0(this.this$1).getToolkit().getHyperlinkGroup().getForeground());
                    }
                });
                return hyperlink;
            }

            static /* synthetic */ TargetEditor access$0(2 var0) {
                return var0.TargetEditor.this;
            }
        };
        manager.add((IContributionItem)save);
    }

    private void doLoadTarget() {
        IRunnableWithProgress run = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    ITargetModel model = TargetEditor.this.getTargetModel();
                    if (!model.isLoaded()) {
                        MessageDialog.openError((Shell)TargetEditor.this.getActiveEditor().getSite().getShell(), (String)PDEUIMessages.TargetPlatformPreferencePage_invalidTitle, (String)PDEUIMessages.TargetPlatformPreferencePage_invalidDescription);
                        monitor.done();
                        return;
                    }
                    try {
                        LoadTargetOperation op = new LoadTargetOperation(TargetEditor.this.getTarget(), TargetEditor.this.getFilePath());
                        PDEPlugin.getWorkspace().run((IWorkspaceRunnable)op, monitor);
                        Object[] features = op.getMissingFeatures();
                        Object[] plugins = op.getMissingPlugins();
                        if (plugins.length + features.length > 0) {
                            TargetErrorDialog.showDialog(TargetEditor.this.getActiveEditor().getSite().getShell(), features, plugins);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException(e.getMessage());
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.runInUI((IRunnableContext)service, run, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    private ITarget getTarget() {
        return this.getTargetModel().getTarget();
    }

    private ITargetModel getTargetModel() {
        return (ITargetModel)this.getAggregateModel();
    }

    private IPath getFilePath() {
        IFile file;
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null) {
            return file.getFullPath();
        }
        return null;
    }

    static /* synthetic */ void access$0(TargetEditor targetEditor) {
        targetEditor.doLoadTarget();
    }
}

