/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.target;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.core.itarget.ITargetObject;
import org.eclipse.pde.internal.core.itarget.ITargetPlugin;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.target.ContentPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.editor.FormPage;

public class TargetOutlinePage
extends FormOutlinePage {
    private TargetContentNode pNode;
    private TargetContentNode fNode;

    public TargetOutlinePage(PDEFormEditor editor) {
        super(editor);
    }

    public void modelChanged(IModelChangedEvent event) {
        if ("useAllPlugins".equals(event.getChangedProperty()) || event.getChangeType() == 99) {
            super.modelChanged(event);
            return;
        }
        if (event.getChangeType() == 1 || event.getChangeType() == 2) {
            Object object = event.getChangedObjects()[0];
            if (object instanceof ITargetPlugin) {
                this.getTreeViewer().refresh((Object)this.pNode);
            } else {
                this.getTreeViewer().refresh((Object)this.fNode);
            }
            return;
        }
    }

    protected Object[] getChildren(Object parent) {
        if (parent instanceof ContentPage) {
            ContentPage page = (ContentPage)((Object)parent);
            ITarget target = ((ITargetModel)page.getModel()).getTarget();
            if (target.useAllPlugins()) {
                return new Object[0];
            }
            if (this.pNode == null) {
                this.pNode = new TargetContentNode(target, false);
            }
            if (this.fNode == null) {
                this.fNode = new TargetContentNode(target, true);
            }
            return new Object[]{this.pNode, this.fNode};
        }
        if (parent instanceof TargetContentNode) {
            return ((TargetContentNode)parent).getModels();
        }
        return new Object[0];
    }

    public ILabelProvider createLabelProvider() {
        return new FormOutlinePage.BasicLabelProvider(this){

            public Image getImage(Object element) {
                PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
                if (element instanceof TargetContentNode) {
                    if (((TargetContentNode)element).isFeatureBased()) {
                        return provider.get(PDEPluginImages.DESC_FEATURE_OBJ);
                    }
                    return provider.get(PDEPluginImages.DESC_PLUGIN_OBJ);
                }
                if (element instanceof FormPage) {
                    return super.getImage(element);
                }
                return provider.getImage(element);
            }
        };
    }

    public class TargetContentNode {
        private ITarget fTarget;
        private boolean fFeatureBased = false;

        public String toString() {
            return this.fFeatureBased ? PDEUIMessages.TargetOutlinePage_features : PDEUIMessages.TargetOutlinePage_plugins;
        }

        public TargetContentNode(ITarget target, boolean featureBased) {
            this.fTarget = target;
            this.fFeatureBased = featureBased;
        }

        public ITargetObject[] getModels() {
            if (this.fTarget.useAllPlugins()) {
                return new ITargetObject[0];
            }
            if (this.fFeatureBased) {
                return this.fTarget.getFeatures();
            }
            return this.fTarget.getPlugins();
        }

        public boolean isFeatureBased() {
            return this.fFeatureBased;
        }
    }
}

