/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.target;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.itarget.IArgumentsInfo;
import org.eclipse.pde.internal.core.itarget.IEnvironmentInfo;
import org.eclipse.pde.internal.core.itarget.IImplicitDependenciesInfo;
import org.eclipse.pde.internal.core.itarget.ILocationInfo;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetJRE;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class TargetProfileWindow
extends ApplicationWindow {
    protected ITargetModel fTargetModel;
    private FormToolkit fToolkit;
    private String fTargetName;

    public TargetProfileWindow(Shell parentShell, ITargetModel model, String targetName) {
        super(parentShell);
        this.setShellStyle(66640);
        this.fTargetModel = model;
        this.fTargetName = targetName;
    }

    public void create() {
        super.create();
        this.getShell().setText(PDEUIMessages.TargetProfileWindow_title);
        this.getShell().setSize(500, 300);
    }

    protected Control createContents(Composite parent) {
        IImplicitDependenciesInfo info;
        this.fToolkit = new FormToolkit(parent.getDisplay());
        CTabFolder folder = new CTabFolder(parent, 0);
        folder.setLayout((Layout)new GridLayout());
        this.fToolkit.adapt((Control)folder, true, true);
        this.fToolkit.adapt(parent);
        this.fToolkit.getColors().initializeSectionToolBarColors();
        Color selectedColor = this.fToolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        folder.setSelectionBackground(new Color[]{selectedColor, this.fToolkit.getColors().getBackground()}, new int[]{100}, true);
        CTabItem item = new CTabItem(folder, 0);
        item.setControl(this.createDefinitionTab((Composite)folder, this.fToolkit));
        item.setText(PDEUIMessages.TargetProfileWindow_definition);
        ITarget target = this.fTargetModel.getTarget();
        Object[] plugins = target.getPlugins();
        if (!target.useAllPlugins() && plugins.length > 0) {
            item = new CTabItem(folder, 0);
            item.setControl(this.createTabularTab((Composite)folder, this.fToolkit, plugins));
            item.setText(PDEUIMessages.TargetProfileWindow_plugins);
        }
        Object[] features = target.getFeatures();
        if (!target.useAllPlugins() && features.length > 0) {
            item = new CTabItem(folder, 0);
            item.setControl(this.createTabularTab((Composite)folder, this.fToolkit, features));
            item.setText(PDEUIMessages.TargetProfileWindow_features);
        }
        item = new CTabItem(folder, 0);
        item.setControl(this.createEnvironmentTab((Composite)folder, this.fToolkit));
        item.setText(PDEUIMessages.TargetProfileWindow_environment);
        IArgumentsInfo argInfo = target.getArguments();
        if (argInfo != null) {
            item = new CTabItem(folder, 0);
            item.setControl(this.createArgumentsTab((Composite)folder, this.fToolkit, argInfo));
            item.setText(PDEUIMessages.TargetProfileWindow_launching);
        }
        if ((info = target.getImplicitPluginsInfo()) != null) {
            item = new CTabItem(folder, 0);
            item.setControl(this.createTabularTab((Composite)folder, this.fToolkit, info.getPlugins()));
            item.setText(PDEUIMessages.TargetProfileWindow_implicit);
        }
        return folder;
    }

    private Control createDefinitionTab(Composite parent, FormToolkit toolkit) {
        String desc;
        ScrolledForm form = toolkit.createScrolledForm(parent);
        Composite body = form.getBody();
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        body.setLayout((Layout)layout);
        ITarget target = this.fTargetModel.getTarget();
        this.createEntry(body, toolkit, PDEUIMessages.TargetDefinitionSection_name, this.fTargetName);
        this.createEntry(body, toolkit, PDEUIMessages.TargetDefinitionSection_targetLocation, this.getLocation(target));
        Object[] locs = target.getAdditionalDirectories();
        if (locs.length > 0) {
            Label label = toolkit.createLabel(body, PDEUIMessages.TargetProfileWindow_additionalLocations);
            label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            label.setLayoutData((Object)new GridData(2));
            this.createTable(body, toolkit, locs);
        }
        if ((desc = target.getDescription()) != null) {
            FormEntry entry = this.createEntry(body, toolkit, PDEUIMessages.TargetProfileWindow_targetDescription, desc, 576);
            GridData gd = new GridData(1808);
            gd.widthHint = 200;
            entry.getText().setLayoutData((Object)gd);
            entry.getLabel().setLayoutData((Object)new GridData(2));
        }
        toolkit.paintBordersFor(form.getBody());
        return form;
    }

    private Control createEnvironmentTab(Composite parent, FormToolkit toolkit) {
        ScrolledForm form = toolkit.createScrolledForm(parent);
        Composite body = form.getBody();
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        body.setLayout((Layout)layout);
        ITarget target = this.fTargetModel.getTarget();
        IEnvironmentInfo info = target.getEnvironment();
        String os = info == null ? Platform.getOS() : info.getDisplayOS();
        this.createEntry(body, toolkit, PDEUIMessages.EnvironmentSection_operationSystem, os);
        String ws = info == null ? Platform.getWS() : info.getDisplayWS();
        this.createEntry(body, toolkit, PDEUIMessages.EnvironmentSection_windowingSystem, ws);
        String arch = info == null ? Platform.getOSArch() : info.getDisplayArch();
        this.createEntry(body, toolkit, PDEUIMessages.EnvironmentSection_architecture, arch);
        String nl = info == null ? Platform.getNL() : info.getDisplayNL();
        this.createEntry(body, toolkit, PDEUIMessages.EnvironmentSection_locale, nl);
        ITargetJRE jreInfo = target.getTargetJREInfo();
        String jre = jreInfo == null ? JavaRuntime.getDefaultVMInstall().getName() : jreInfo.getCompatibleJRE();
        this.createEntry(body, toolkit, PDEUIMessages.TargetProfileWindow_jre, jre);
        toolkit.paintBordersFor(form.getBody());
        return form;
    }

    private Control createTabularTab(Composite parent, FormToolkit toolkit, Object[] objects) {
        ScrolledForm form = toolkit.createScrolledForm(parent);
        Composite body = form.getBody();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        body.setLayout((Layout)layout);
        this.createTable(body, toolkit, objects);
        toolkit.paintBordersFor(form.getBody());
        return form;
    }

    private Control createTable(Composite parent, FormToolkit toolkit, Object[] objects) {
        int style = 0x300 | toolkit.getBorderStyle();
        TableViewer tableViewer = new TableViewer(parent, style);
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        tableViewer.setInput((Object)objects);
        tableViewer.getControl().setLayoutData((Object)new GridData(1808));
        return tableViewer.getControl();
    }

    private Control createArgumentsTab(Composite parent, FormToolkit toolkit, IArgumentsInfo info) {
        ScrolledForm form = toolkit.createScrolledForm(parent);
        Composite body = form.getBody();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        body.setLayout((Layout)layout);
        FormEntry entry = this.createEntry(body, toolkit, PDEUIMessages.TargetProfileWindow_program, info.getProgramArguments());
        entry.getText().setLayoutData((Object)new GridData(1808));
        entry = this.createEntry(body, toolkit, PDEUIMessages.TargetProfileWindow_vm, info.getVMArguments());
        entry.getText().setLayoutData((Object)new GridData(1808));
        toolkit.paintBordersFor(form.getBody());
        return form;
    }

    private FormEntry createEntry(Composite client, FormToolkit toolkit, String text, String value) {
        return this.createEntry(client, toolkit, text, value, 0);
    }

    private FormEntry createEntry(Composite client, FormToolkit toolkit, String text, String value, int style) {
        FormEntry entry = new FormEntry(client, toolkit, text, style);
        entry.setValue(value);
        entry.setEditable(false);
        return entry;
    }

    private String getLocation(ITarget target) {
        ILocationInfo info = target.getLocationInfo();
        if (info == null || info.useDefault()) {
            return TargetPlatform.getDefaultLocation();
        }
        try {
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(info.getPath());
        }
        catch (CoreException coreException) {
            return "";
        }
    }

    public boolean close() {
        this.fToolkit.dispose();
        return super.close();
    }
}

