/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.toc;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.toc.TocModel;
import org.eclipse.pde.internal.core.text.toc.TocObject;
import org.eclipse.pde.internal.ui.editor.PDEHyperlinkDetector;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.text.ResourceHyperlink;

public class TocHyperlinkDetector
extends PDEHyperlinkDetector {
    public TocHyperlinkDetector(PDESourcePage page) {
        super(page);
    }

    protected IHyperlink[] detectAttributeHyperlink(IDocumentAttributeNode attr) {
        String attrValue = attr.getAttributeValue();
        if (attrValue.length() == 0) {
            return null;
        }
        IDocumentElementNode node = attr.getEnclosingElement();
        if (node == null || !(node instanceof TocObject) || !((TocObject)node).getModel().isEditable()) {
            return null;
        }
        TocObject tocObject = (TocObject)node;
        TocModel model = tocObject.getModel();
        IResource res = model.getUnderlyingResource();
        Region linkRegion = new Region(attr.getValueOffset(), attr.getValueLength());
        IHyperlink[] link = new IHyperlink[1];
        if (tocObject.getType() == 0) {
            if (attr.getAttributeName().equals("topic")) {
                link[0] = new ResourceHyperlink((IRegion)linkRegion, attrValue, res);
            }
        } else if (tocObject.getType() == 1) {
            if (attr.getAttributeName().equals("href")) {
                link[0] = new ResourceHyperlink((IRegion)linkRegion, attrValue, res);
            }
        } else if (tocObject.getType() == 3 && attr.getAttributeName().equals("toc")) {
            link[0] = new ResourceHyperlink((IRegion)linkRegion, attrValue, res);
        }
        if (link[0] != null) {
            return link;
        }
        return null;
    }
}

