/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.ui.launcher.AbstractPluginBlock;
import org.eclipse.pde.internal.ui.launcher.EclipsePluginValidationOperation;
import org.eclipse.pde.internal.ui.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.ui.launcher.LaunchValidationOperation;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;

public class PluginBlock
extends AbstractPluginBlock {
    protected ILaunchConfiguration fLaunchConfig;

    public PluginBlock(AbstractLauncherTab tab) {
        super(tab);
    }

    public void initializeFrom(ILaunchConfiguration config, boolean customSelection) throws CoreException {
        super.initializeFrom(config);
        if (customSelection) {
            this.initWorkspacePluginsState(config);
            this.initExternalPluginsState(config);
        } else {
            this.handleRestoreDefaults();
        }
        this.enableViewer(customSelection);
        this.updateCounter();
        this.fTab.updateLaunchConfigurationDialog();
        this.fLaunchConfig = config;
        this.handleFilterButton();
    }

    protected void initWorkspacePluginsState(ILaunchConfiguration configuration) throws CoreException {
        boolean automaticAdd = configuration.getAttribute("automaticAdd", true);
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fWorkspacePlugins, automaticAdd);
        this.fNumWorkspaceChecked = automaticAdd ? this.fWorkspaceModels.length : 0;
        String attribute = automaticAdd ? "deselected_workspace_plugins" : "selected_workspace_plugins";
        Set bundles = LaunchPluginValidator.parsePlugins(configuration, attribute);
        Iterator it = bundles.iterator();
        while (it.hasNext()) {
            IPluginModelBase base = (IPluginModelBase)it.next();
            this.fPluginTreeViewer.setChecked((Object)base, !automaticAdd);
            int n = this.fNumWorkspaceChecked = automaticAdd ? this.fNumWorkspaceChecked - 1 : this.fNumWorkspaceChecked + 1;
        }
        this.fPluginTreeViewer.setChecked((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0 && this.fNumWorkspaceChecked < this.fWorkspaceModels.length);
    }

    protected void initExternalPluginsState(ILaunchConfiguration config) throws CoreException {
        this.fNumExternalChecked = 0;
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fExternalPlugins, false);
        Set selected = LaunchPluginValidator.parsePlugins(config, "selected_target_plugins");
        Iterator it = selected.iterator();
        while (it.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)it.next();
            this.fPluginTreeViewer.setChecked((Object)model, true);
            ++this.fNumExternalChecked;
        }
        this.fPluginTreeViewer.setChecked((Object)this.fExternalPlugins, this.fNumExternalChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fExternalPlugins, this.fNumExternalChecked > 0 && this.fNumExternalChecked < this.fExternalModels.length);
    }

    protected void savePluginState(ILaunchConfigurationWorkingCopy config) {
        if (this.isEnabled()) {
            String value;
            StringBuffer wbuf = new StringBuffer();
            int i = 0;
            while (i < this.fWorkspaceModels.length) {
                IPluginModelBase model = this.fWorkspaceModels[i];
                if (this.fPluginTreeViewer.getChecked((Object)model) != this.fAddWorkspaceButton.getSelection()) {
                    this.appendBundle(wbuf, model);
                }
                ++i;
            }
            String string = value = wbuf.length() > 0 ? wbuf.toString() : null;
            if (this.fAddWorkspaceButton.getSelection()) {
                config.setAttribute("deselected_workspace_plugins", value);
                config.setAttribute("selected_workspace_plugins", null);
            } else {
                config.setAttribute("selected_workspace_plugins", value);
            }
            StringBuffer exbuf = new StringBuffer();
            Object[] checked = this.fPluginTreeViewer.getCheckedElements();
            int i2 = 0;
            while (i2 < checked.length) {
                IPluginModelBase model;
                if (checked[i2] instanceof IPluginModelBase && (model = (IPluginModelBase)checked[i2]).getUnderlyingResource() == null) {
                    this.appendBundle(exbuf, model);
                }
                ++i2;
            }
            value = exbuf.length() > 0 ? exbuf.toString() : null;
            config.setAttribute("selected_target_plugins", value);
        } else {
            config.setAttribute("selected_target_plugins", null);
            config.setAttribute("selected_workspace_plugins", null);
            config.setAttribute("deselected_workspace_plugins", null);
        }
    }

    private void appendBundle(StringBuffer buffer, IPluginModelBase model) {
        if (buffer.length() > 0) {
            buffer.append(",");
        }
        String id = model.getPluginBase().getId();
        buffer.append(id);
        ModelEntry entry = PluginRegistry.findEntry((String)id);
        if (entry.getActiveModels().length > 1) {
            buffer.append('*');
            buffer.append(model.getPluginBase().getVersion());
        }
    }

    protected void computeSubset() {
        this.validateExtensions();
        super.computeSubset();
    }

    private void validateExtensions() {
        try {
            if (this.fLaunchConfig.getAttribute("useProduct", true)) {
                String product = this.fLaunchConfig.getAttribute("product", null);
                if (product != null) {
                    this.validateLaunchId(product);
                    String application = this.getApplication(product);
                    if (application != null) {
                        this.validateLaunchId(application);
                    }
                }
            } else {
                String configType = this.fLaunchConfig.getType().getIdentifier();
                String attribute = configType.equals("org.eclipse.pde.ui.RuntimeWorkbench") ? "application" : "testApplication";
                String application = this.fLaunchConfig.getAttribute(attribute, TargetPlatform.getDefaultApplication());
                if (!"org.eclipse.pde.junit.runtime.coretestapplication".equals(application)) {
                    this.validateLaunchId(application);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private void validateLaunchId(String launchId) {
        String pluginId;
        IPluginModelBase base;
        int index;
        if (launchId != null && (index = launchId.lastIndexOf(46)) > 0 && (base = this.findPlugin(pluginId = launchId.substring(0, index))) == null && (base = PluginRegistry.findModel((String)pluginId)) != null) {
            this.fPluginTreeViewer.setChecked((Object)base, true);
        }
    }

    private String getApplication(String product) {
        String bundleID = product.substring(0, product.lastIndexOf(46));
        IPluginModelBase model = this.findPlugin(bundleID);
        if (model != null) {
            IPluginExtension[] extensions = model.getPluginBase().getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IPluginElement prod;
                IPluginExtension ext = extensions[i];
                String point = ext.getPoint();
                if ("org.eclipse.core.runtime.products".equals(point) && product.equals(IdUtil.getFullId((IPluginExtension)ext)) && ext.getChildCount() == 1 && (prod = (IPluginElement)ext.getChildren()[0]).getName().equals("product")) {
                    IPluginAttribute attr = prod.getAttribute("application");
                    return attr != null ? attr.getValue() : null;
                }
                ++i;
            }
        }
        return null;
    }

    protected LaunchValidationOperation createValidationOperation() {
        return new EclipsePluginValidationOperation(this.fLaunchConfig);
    }

    protected void refreshTreeView(CheckboxTreeViewer treeView) {
        treeView.setSelection((ISelection)StructuredSelection.EMPTY);
    }
}

